/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn.core;

import android.content.Context;
import android.os.Build;
import android.os.HandlerThread;
import android.os.Message;
import de.blinkt.openvpn.R;
import de.blinkt.openvpn.core.LogFileHandler;
import de.blinkt.openvpn.core.LogItem;
import de.blinkt.openvpn.core.NativeUtils;
import de.blinkt.openvpn.core.OpenVPNManagement;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Vector;

public class VpnStatus {
    public static final byte[] officalkey = new byte[]{-58, -42, -44, -106, 90, -88, -87, -88, -52, -124, 84, 117, 66, 79, -112, -111, -46, 86, -37, 109};
    public static final byte[] officaldebugkey = new byte[]{-99, -69, 45, 71, 114, -116, 82, 66, -99, -122, 50, -70, -56, -111, 98, -35, -65, 105, 82, 43};
    public static final byte[] amazonkey = new byte[]{-116, -115, -118, -89, -116, -112, 120, 55, 79, -8, -119, -23, 106, -114, -85, -56, -4, 105, 26, -57};
    public static final byte[] fdroidkey = new byte[]{-92, 111, -42, -46, 123, -96, -60, 79, -27, -31, 49, 103, 11, -54, -68, -27, 17, 2, 121, 104};
    static final int MAXLOGENTRIES = 1000;
    public static LinkedList<LogItem> logbuffer;
    private static Vector<LogListener> logListener;
    private static Vector<StateListener> stateListener;
    private static Vector<ByteCountListener> byteCountListener;
    private static String mLaststatemsg;
    private static String mLaststate;
    private static int mLastStateresid;
    private static long[] mlastByteCount;
    private static HandlerThread mHandlerThread;
    private static ConnectionStatus mLastLevel;
    private static LogFileHandler mLogFileHandler;

    public static void logException(LogLevel ll, String context, Exception e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        LogItem li = context != null ? new LogItem(ll, R.string.unhandled_exception_context, e.getMessage(), sw.toString(), context) : new LogItem(ll, R.string.unhandled_exception, e.getMessage(), sw.toString());
        VpnStatus.newLogItem(li);
    }

    public static void logException(Exception e) {
        VpnStatus.logException(LogLevel.ERROR, null, e);
    }

    public static void logException(String context, Exception e) {
        VpnStatus.logException(LogLevel.ERROR, context, e);
    }

    public static boolean isVPNActive() {
        return mLastLevel != ConnectionStatus.LEVEL_AUTH_FAILED && mLastLevel != ConnectionStatus.LEVEL_NOTCONNECTED;
    }

    public static String getLastCleanLogMessage(Context c) {
        String message = mLaststatemsg;
        switch (mLastLevel) {
            case LEVEL_CONNECTED: {
                String[] parts = mLaststatemsg.split(",");
                if (parts.length < 7) break;
                message = String.format(Locale.US, "%s %s", parts[1], parts[6]);
            }
        }
        while (message.endsWith(",")) {
            message = message.substring(0, message.length() - 1);
        }
        String status = mLaststate;
        if (status.equals("NOPROCESS")) {
            return message;
        }
        if (mLastStateresid == R.string.state_waitconnectretry) {
            return c.getString(R.string.state_waitconnectretry, new Object[]{mLaststatemsg});
        }
        String prefix = c.getString(mLastStateresid);
        if (mLastStateresid == R.string.unknown_state) {
            message = status + message;
        }
        if (message.length() > 0) {
            prefix = prefix + ": ";
        }
        return prefix + message;
    }

    public static void initLogCache(File cacheDir) {
        mHandlerThread = new HandlerThread("LogFileWriter", 1);
        mHandlerThread.start();
        mLogFileHandler = new LogFileHandler(mHandlerThread.getLooper());
        Message m = mLogFileHandler.obtainMessage(102, cacheDir);
        mLogFileHandler.sendMessage(m);
    }

    public static void flushLog() {
        if (mLogFileHandler != null) {
            mLogFileHandler.sendEmptyMessage(101);
        }
    }

    public static synchronized void logMessage(LogLevel level, String prefix, String message) {
        VpnStatus.newLogItem(new LogItem(level, prefix + message));
    }

    public static synchronized void clearLog() {
        logbuffer.clear();
        VpnStatus.logInformation();
        if (mLogFileHandler != null) {
            mLogFileHandler.sendEmptyMessage(100);
        }
    }

    private static void logInformation() {
        String nativeAPI;
        try {
            nativeAPI = NativeUtils.getNativeAPI();
        }
        catch (UnsatisfiedLinkError ignore) {
            nativeAPI = "error";
        }
        VpnStatus.logInfo(R.string.mobile_info, Build.MODEL, Build.BOARD, Build.BRAND, Build.VERSION.SDK_INT, nativeAPI, Build.VERSION.RELEASE, Build.ID, Build.FINGERPRINT, "", "");
    }

    public static synchronized void addLogListener(LogListener ll) {
        logListener.add(ll);
    }

    public static synchronized void removeLogListener(LogListener ll) {
        logListener.remove(ll);
    }

    public static synchronized void addByteCountListener(ByteCountListener bcl) {
        bcl.updateByteCount(mlastByteCount[0], mlastByteCount[1], mlastByteCount[2], mlastByteCount[3]);
        byteCountListener.add(bcl);
    }

    public static synchronized void removeByteCountListener(ByteCountListener bcl) {
        byteCountListener.remove(bcl);
    }

    public static synchronized void addStateListener(StateListener sl) {
        if (!stateListener.contains(sl)) {
            stateListener.add(sl);
            if (mLaststate != null) {
                sl.updateState(mLaststate, mLaststatemsg, mLastStateresid, mLastLevel);
            }
        }
    }

    private static int getLocalizedState(String state) {
        switch (state) {
            case "CONNECTING": {
                return R.string.state_connecting;
            }
            case "WAIT": {
                return R.string.state_wait;
            }
            case "AUTH": {
                return R.string.state_auth;
            }
            case "GET_CONFIG": {
                return R.string.state_get_config;
            }
            case "ASSIGN_IP": {
                return R.string.state_assign_ip;
            }
            case "ADD_ROUTES": {
                return R.string.state_add_routes;
            }
            case "CONNECTED": {
                return R.string.state_connected;
            }
            case "DISCONNECTED": {
                return R.string.state_disconnected;
            }
            case "RECONNECTING": {
                return R.string.state_reconnecting;
            }
            case "EXITING": {
                return R.string.state_exiting;
            }
            case "RESOLVE": {
                return R.string.state_resolve;
            }
            case "TCP_CONNECT": {
                return R.string.state_tcp_connect;
            }
        }
        return R.string.unknown_state;
    }

    public static void updateStatePause(OpenVPNManagement.pauseReason pauseReason2) {
        switch (pauseReason2) {
            case noNetwork: {
                VpnStatus.updateStateString("NONETWORK", "", R.string.state_nonetwork, ConnectionStatus.LEVEL_NONETWORK);
                break;
            }
            case screenOff: {
                VpnStatus.updateStateString("SCREENOFF", "", R.string.state_screenoff, ConnectionStatus.LEVEL_VPNPAUSED);
                break;
            }
            case userPause: {
                VpnStatus.updateStateString("USERPAUSE", "", R.string.state_userpause, ConnectionStatus.LEVEL_VPNPAUSED);
            }
        }
    }

    private static ConnectionStatus getLevel(String state) {
        String[] noreplyet = new String[]{"CONNECTING", "WAIT", "RECONNECTING", "RESOLVE", "TCP_CONNECT"};
        String[] reply = new String[]{"AUTH", "GET_CONFIG", "ASSIGN_IP", "ADD_ROUTES"};
        String[] connected = new String[]{"CONNECTED"};
        String[] notconnected = new String[]{"DISCONNECTED", "EXITING"};
        for (String x : noreplyet) {
            if (!state.equals(x)) continue;
            return ConnectionStatus.LEVEL_CONNECTING_NO_SERVER_REPLY_YET;
        }
        for (String x : reply) {
            if (!state.equals(x)) continue;
            return ConnectionStatus.LEVEL_CONNECTING_SERVER_REPLIED;
        }
        for (String x : connected) {
            if (!state.equals(x)) continue;
            return ConnectionStatus.LEVEL_CONNECTED;
        }
        for (String x : notconnected) {
            if (!state.equals(x)) continue;
            return ConnectionStatus.LEVEL_NOTCONNECTED;
        }
        return ConnectionStatus.UNKNOWN_LEVEL;
    }

    public static synchronized void removeStateListener(StateListener sl) {
        stateListener.remove(sl);
    }

    public static synchronized LogItem[] getlogbuffer() {
        return logbuffer.toArray(new LogItem[logbuffer.size()]);
    }

    public static void updateStateString(String state, String msg) {
        int rid = VpnStatus.getLocalizedState(state);
        ConnectionStatus level = VpnStatus.getLevel(state);
        VpnStatus.updateStateString(state, msg, rid, level);
    }

    public static synchronized void updateStateString(String state, String msg, int resid, ConnectionStatus level) {
        try {
            if (mLastLevel == ConnectionStatus.LEVEL_CONNECTED && (state.equals("WAIT") || state.equals("AUTH"))) {
                VpnStatus.newLogItem(new LogItem(LogLevel.DEBUG, String.format("Ignoring Fastestvpn Status in CONNECTED state (%s->%s): %s", state, level.toString(), msg)));
                return;
            }
            mLaststate = state;
            mLaststatemsg = msg;
            mLastStateresid = resid;
            mLastLevel = level;
            for (StateListener sl : stateListener) {
                sl.updateState(state, msg, resid, level);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void logInfo(String message) {
        VpnStatus.newLogItem(new LogItem(LogLevel.INFO, message));
    }

    public static void logDebug(String message) {
        VpnStatus.newLogItem(new LogItem(LogLevel.DEBUG, message));
    }

    public static void logInfo(int resourceId, Object ... args) {
        VpnStatus.newLogItem(new LogItem(LogLevel.INFO, resourceId, args));
    }

    public static void logDebug(int resourceId, Object ... args) {
        VpnStatus.newLogItem(new LogItem(LogLevel.DEBUG, resourceId, args));
    }

    private static void newLogItem(LogItem logItem) {
        VpnStatus.newLogItem(logItem, false);
    }

    static synchronized void newLogItem(LogItem logItem, boolean cachedLine) {
        if (cachedLine) {
            logbuffer.addFirst(logItem);
        } else {
            logbuffer.addLast(logItem);
            if (mLogFileHandler != null) {
                Message m = mLogFileHandler.obtainMessage(103, logItem);
                mLogFileHandler.sendMessage(m);
            }
        }
        if (logbuffer.size() > 1500) {
            while (logbuffer.size() > 1000) {
                logbuffer.removeFirst();
            }
            if (mLogFileHandler != null) {
                mLogFileHandler.sendMessage(mLogFileHandler.obtainMessage(100));
            }
        }
        for (LogListener ll : logListener) {
            ll.newLog(logItem);
        }
    }

    public static void logError(String msg) {
        VpnStatus.newLogItem(new LogItem(LogLevel.ERROR, msg));
    }

    public static void logWarning(int resourceId, Object ... args) {
        VpnStatus.newLogItem(new LogItem(LogLevel.WARNING, resourceId, args));
    }

    public static void logWarning(String msg) {
        VpnStatus.newLogItem(new LogItem(LogLevel.WARNING, msg));
    }

    public static void logError(int resourceId) {
        VpnStatus.newLogItem(new LogItem(LogLevel.ERROR, resourceId));
    }

    public static void logError(int resourceId, Object ... args) {
        VpnStatus.newLogItem(new LogItem(LogLevel.ERROR, resourceId, args));
    }

    public static void logMessageOpenVPN(LogLevel level, int ovpnlevel, String message) {
        VpnStatus.newLogItem(new LogItem(level, ovpnlevel, message));
    }

    public static synchronized void updateByteCount(long in, long out) {
        long lastIn = mlastByteCount[0];
        long lastOut = mlastByteCount[1];
        long diffIn = VpnStatus.mlastByteCount[2] = Math.max(0L, in - lastIn);
        long diffOut = VpnStatus.mlastByteCount[3] = Math.max(0L, out - lastOut);
        mlastByteCount = new long[]{in, out, diffIn, diffOut};
        for (ByteCountListener bcl : byteCountListener) {
            bcl.updateByteCount(in, out, diffIn, diffOut);
        }
    }

    static {
        mLaststatemsg = "";
        mLaststate = "NOPROCESS";
        mLastStateresid = R.string.state_noprocess;
        mlastByteCount = new long[]{0L, 0L, 0L, 0L};
        mLastLevel = ConnectionStatus.LEVEL_NOTCONNECTED;
        logbuffer = new LinkedList();
        logListener = new Vector();
        stateListener = new Vector();
        byteCountListener = new Vector();
        VpnStatus.logInformation();
    }

    public static interface ByteCountListener {
        public void updateByteCount(long var1, long var3, long var5, long var7);
    }

    public static interface StateListener {
        public void updateState(String var1, String var2, int var3, ConnectionStatus var4);
    }

    public static interface LogListener {
        public void newLog(LogItem var1);
    }

    public static enum LogLevel {
        INFO(2),
        ERROR(-2),
        WARNING(1),
        VERBOSE(3),
        DEBUG(4);

        protected int mValue;

        private LogLevel(int value) {
            this.mValue = value;
        }

        public static LogLevel getEnumByValue(int value) {
            switch (value) {
                case 1: {
                    return INFO;
                }
                case 2: {
                    return ERROR;
                }
                case 3: {
                    return WARNING;
                }
                case 4: {
                    return DEBUG;
                }
            }
            return null;
        }

        public int getInt() {
            return this.mValue;
        }
    }

    public static enum ConnectionStatus {
        LEVEL_CONNECTED,
        LEVEL_VPNPAUSED,
        LEVEL_CONNECTING_SERVER_REPLIED,
        LEVEL_CONNECTING_NO_SERVER_REPLY_YET,
        LEVEL_NONETWORK,
        LEVEL_NOTCONNECTED,
        LEVEL_START,
        LEVEL_AUTH_FAILED,
        LEVEL_WAITING_FOR_USER_INPUT,
        UNKNOWN_LEVEL;

    }
}

