/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn.core;

import android.content.Context;
import android.net.LocalServerSocket;
import android.net.LocalSocket;
import android.net.LocalSocketAddress;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.support.annotation.NonNull;
import android.util.Log;
import de.blinkt.openvpn.BuildConfig;
import de.blinkt.openvpn.R;
import de.blinkt.openvpn.VpnProfile;
import de.blinkt.openvpn.core.NativeUtils;
import de.blinkt.openvpn.core.OpenVPNManagement;
import de.blinkt.openvpn.core.OpenVPNService;
import de.blinkt.openvpn.core.ProxyDetection;
import de.blinkt.openvpn.core.VpnStatus;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Vector;
import junit.framework.Assert;

public class OpenVpnManagementThread
implements Runnable,
OpenVPNManagement {
    private static final String TAG = "Fastestvpn";
    private static final Vector<OpenVpnManagementThread> active = new Vector();
    private final Handler mResumeHandler;
    private LocalSocket mSocket;
    private VpnProfile mProfile;
    private OpenVPNService mOpenVPNService;
    private LinkedList<FileDescriptor> mFDList = new LinkedList();
    private LocalServerSocket mServerSocket;
    private boolean mWaitingForRelease = false;
    private long mLastHoldRelease = 0L;
    private LocalSocket mServerSocketLocal;
    private OpenVPNManagement.pauseReason lastPauseReason = OpenVPNManagement.pauseReason.noNetwork;
    private OpenVPNManagement.PausedStateCallback mPauseCallback;
    private boolean mShuttingDown;
    private Runnable mResumeHoldRunnable = new Runnable(){

        @Override
        public void run() {
            if (OpenVpnManagementThread.this.shouldBeRunning()) {
                OpenVpnManagementThread.this.releaseHoldCmd();
            }
        }
    };

    public OpenVpnManagementThread(VpnProfile profile, OpenVPNService openVpnService) {
        this.mProfile = profile;
        this.mOpenVPNService = openVpnService;
        this.mResumeHandler = new Handler(openVpnService.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean stopOpenVPN() {
        Vector<OpenVpnManagementThread> vector = active;
        synchronized (vector) {
            boolean sendCMD = false;
            for (OpenVpnManagementThread mt : active) {
                sendCMD = mt.managmentCommand("signal SIGINT\n");
                try {
                    if (mt.mSocket == null) continue;
                    mt.mSocket.close();
                }
                catch (IOException iOException) {}
            }
            return sendCMD;
        }
    }

    public boolean openManagementInterface(@NonNull Context c) {
        String socketName = c.getCacheDir().getAbsolutePath() + "/mgmtsocket";
        this.mServerSocketLocal = new LocalSocket();
        for (int tries = 8; tries > 0 && !this.mServerSocketLocal.isBound(); --tries) {
            try {
                this.mServerSocketLocal.bind(new LocalSocketAddress(socketName, LocalSocketAddress.Namespace.FILESYSTEM));
                continue;
            }
            catch (IOException e) {
                try {
                    Thread.sleep(300L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        try {
            this.mServerSocket = new LocalServerSocket(this.mServerSocketLocal.getFileDescriptor());
            return true;
        }
        catch (IOException e) {
            VpnStatus.logException(e);
            return false;
        }
    }

    public boolean managmentCommand(String cmd) {
        try {
            if (this.mSocket != null && this.mSocket.getOutputStream() != null) {
                Log.d((String)TAG, (String)"managmentCommand:  working into socket ----------");
                this.mSocket.getOutputStream().write(cmd.getBytes());
                this.mSocket.getOutputStream().flush();
                return true;
            }
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)("managmentCommand: ----exception---------- " + e));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] buffer = new byte[2048];
        String pendingInput = "";
        Vector<OpenVpnManagementThread> vector = active;
        synchronized (vector) {
            active.add(this);
        }
        try {
            this.mSocket = this.mServerSocket.accept();
            InputStream instream = this.mSocket.getInputStream();
            try {
                this.mServerSocket.close();
            }
            catch (IOException e) {
                VpnStatus.logException(e);
            }
            while (true) {
                int numbytesread;
                if ((numbytesread = instream.read(buffer)) == -1) {
                    return;
                }
                FileDescriptor[] fds = null;
                try {
                    fds = this.mSocket.getAncillaryFileDescriptors();
                }
                catch (IOException e) {
                    VpnStatus.logException("Error reading fds from socket", e);
                }
                if (fds != null) {
                    Collections.addAll(this.mFDList, fds);
                }
                String input = new String(buffer, 0, numbytesread, "UTF-8");
                pendingInput = pendingInput + input;
                pendingInput = this.processInput(pendingInput);
            }
        }
        catch (IOException e) {
            if (!e.getMessage().equals("socket closed") && !e.getMessage().equals("Connection reset by peer")) {
                VpnStatus.logException(e);
            }
            Vector<OpenVpnManagementThread> vector2 = active;
            synchronized (vector2) {
                active.remove(this);
            }
            return;
        }
    }

    private void protectFileDescriptor(FileDescriptor fd) {
        try {
            Method getInt = FileDescriptor.class.getDeclaredMethod("getInt$", new Class[0]);
            int fdint = (Integer)getInt.invoke((Object)fd, new Object[0]);
            boolean result = this.mOpenVPNService.protect(fdint);
            if (!result) {
                VpnStatus.logWarning("Could not protect VPN socket");
            }
            NativeUtils.jniclose(fdint);
            return;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | NullPointerException | InvocationTargetException e) {
            VpnStatus.logException("Failed to retrieve fd from socket (" + fd + ")", e);
            Log.d((String)"Openvpn", (String)("Failed to retrieve fd from socket: " + fd));
            return;
        }
    }

    private String processInput(String pendingInput) {
        while (pendingInput.contains("\n")) {
            String[] tokens = pendingInput.split("\\r?\\n", 2);
            this.processCommand(tokens[0]);
            if (tokens.length == 1) {
                pendingInput = "";
                continue;
            }
            pendingInput = tokens[1];
        }
        return pendingInput;
    }

    private void processCommand(String command) {
        block28: {
            block27: {
                Log.e((String)TAG, (String)("command: " + command));
                if (!command.startsWith(">") || !command.contains(":")) break block27;
                String[] parts = command.split(":", 2);
                String cmd = parts[0].substring(1);
                String argument = parts[1];
                switch (cmd) {
                    case "INFO": {
                        return;
                    }
                    case "PASSWORD": {
                        this.processPWCommand(argument);
                        break;
                    }
                    case "HOLD": {
                        this.handleHold(argument);
                        break;
                    }
                    case "NEED-OK": {
                        this.processNeedCommand(argument);
                        break;
                    }
                    case "BYTECOUNT": {
                        this.processByteCount(argument);
                        break;
                    }
                    case "STATE": {
                        if (!this.mShuttingDown) {
                            this.processState(argument);
                            break;
                        }
                        break block28;
                    }
                    case "PROXY": {
                        this.processProxyCMD(argument);
                        break;
                    }
                    case "LOG": {
                        this.processLogMessage(argument);
                        break;
                    }
                    case "RSA_SIGN": {
                        this.processSignCommand(argument);
                        break;
                    }
                    default: {
                        VpnStatus.logWarning("MGMT: Got unrecognized command" + command);
                        Log.i((String)TAG, (String)("Got unrecognized command" + command));
                        break;
                    }
                }
                break block28;
            }
            if (command.startsWith("SUCCESS:")) {
                VpnStatus.updateStatePause(OpenVPNManagement.pauseReason.success);
                return;
            }
            if (command.startsWith("PROTECTFD: ")) {
                FileDescriptor fdtoprotect = this.mFDList.pollFirst();
                if (fdtoprotect != null) {
                    this.protectFileDescriptor(fdtoprotect);
                }
            } else {
                Log.i((String)TAG, (String)("Got unrecognized line from managment" + command));
                VpnStatus.logWarning("MGMT: Got unrecognized line from management:" + command);
            }
        }
    }

    private void processLogMessage(String argument) {
        VpnStatus.LogLevel level;
        String[] args = argument.split(",", 4);
        Log.d((String)"OpenVPN", (String)argument);
        switch (args[1]) {
            case "I": {
                level = VpnStatus.LogLevel.INFO;
                break;
            }
            case "W": {
                level = VpnStatus.LogLevel.WARNING;
                break;
            }
            case "D": {
                level = VpnStatus.LogLevel.VERBOSE;
                break;
            }
            case "F": {
                level = VpnStatus.LogLevel.ERROR;
                break;
            }
            default: {
                level = VpnStatus.LogLevel.INFO;
            }
        }
        int ovpnlevel = Integer.parseInt(args[2]) & 0xF;
        String msg = args[3];
        if (msg.startsWith("MANAGEMENT: CMD")) {
            ovpnlevel = Math.max(4, ovpnlevel);
        }
        VpnStatus.logMessageOpenVPN(level, ovpnlevel, msg);
    }

    boolean shouldBeRunning() {
        if (this.mPauseCallback == null) {
            return false;
        }
        return this.mPauseCallback.shouldBeRunning();
    }

    private void handleHold(String argument) {
        int waittime = Integer.parseInt(argument.split(":")[1]);
        Log.e((String)TAG, (String)("waittime: " + waittime + ":" + argument));
        if (this.shouldBeRunning()) {
            if (waittime > 1) {
                VpnStatus.updateStateString("CONNECTRETRY", String.valueOf(waittime), R.string.state_waitconnectretry, VpnStatus.ConnectionStatus.LEVEL_CONNECTING_NO_SERVER_REPLY_YET);
            }
            this.mResumeHandler.postDelayed(this.mResumeHoldRunnable, (long)(waittime * 1000));
            if (waittime > 5) {
                Log.e((String)TAG, (String)("" + waittime));
                VpnStatus.logInfo(R.string.state_waitconnectretry, String.valueOf(waittime));
            }
        } else {
            this.mWaitingForRelease = true;
        }
    }

    private void releaseHoldCmd() {
        this.mResumeHandler.removeCallbacks(this.mResumeHoldRunnable);
        if (System.currentTimeMillis() - this.mLastHoldRelease < 5000L) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.mWaitingForRelease = false;
        this.mLastHoldRelease = System.currentTimeMillis();
        this.managmentCommand("hold release\n");
        this.managmentCommand("bytecount 2\n");
        this.managmentCommand("state on\n");
    }

    public void releaseHold() {
        if (this.mWaitingForRelease) {
            this.releaseHoldCmd();
        }
    }

    private void processProxyCMD(String argument) {
        String proto;
        String[] args = argument.split(",", 3);
        SocketAddress proxyaddr = ProxyDetection.detectProxy(this.mProfile);
        if (args.length >= 2 && (proto = args[1]).equals("UDP")) {
            proxyaddr = null;
        }
        if (proxyaddr instanceof InetSocketAddress) {
            InetSocketAddress isa = (InetSocketAddress)proxyaddr;
            VpnStatus.logInfo(R.string.using_proxy, isa.getHostName(), isa.getPort());
            String proxycmd = String.format(Locale.ENGLISH, "proxy HTTP %s %d\n", isa.getHostName(), isa.getPort());
            Log.d((String)TAG, (String)("-------------------- : " + proxycmd));
            this.managmentCommand(proxycmd);
        } else {
            this.managmentCommand("proxy NONE\n");
        }
    }

    private void processState(String argument) {
        String[] args = argument.split(",", 3);
        String currentstate = args[1];
        if (args[2].equals(",,")) {
            VpnStatus.updateStateString(currentstate, "");
        } else {
            VpnStatus.updateStateString(currentstate, args[2]);
        }
    }

    private void processByteCount(String argument) {
        int comma = argument.indexOf(44);
        long in = Long.parseLong(argument.substring(0, comma));
        long out = Long.parseLong(argument.substring(comma + 1));
        VpnStatus.updateByteCount(in, out);
    }

    private void processNeedCommand(String argument) {
        int p1 = argument.indexOf(39);
        int p2 = argument.indexOf(39, p1 + 1);
        String needed = argument.substring(p1 + 1, p2);
        String extra = argument.split(":", 2)[1];
        String status = "ok";
        switch (needed) {
            case "PROTECTFD": {
                FileDescriptor fdtoprotect = this.mFDList.pollFirst();
                this.protectFileDescriptor(fdtoprotect);
                break;
            }
            case "DNSSERVER": {
                this.mOpenVPNService.addDNS(extra);
                break;
            }
            case "DNSDOMAIN": {
                this.mOpenVPNService.setDomain(extra);
                break;
            }
            case "ROUTE": {
                Object[] routeparts = extra.split(" ");
                if (routeparts.length == 5) {
                    if (BuildConfig.DEBUG) {
                        Assert.assertEquals((String)"dev", (String)routeparts[3]);
                    }
                    this.mOpenVPNService.addRoute(routeparts[0], routeparts[1], (String)routeparts[2], (String)routeparts[4]);
                    break;
                }
                if (routeparts.length >= 3) {
                    this.mOpenVPNService.addRoute(routeparts[0], (String)routeparts[1], (String)routeparts[2], null);
                    break;
                }
                VpnStatus.logError("Unrecognized ROUTE cmd:" + Arrays.toString(routeparts) + " | " + argument);
                break;
            }
            case "IFCONFIG": {
                String[] ifconfigparts = extra.split(" ");
                int mtu = Integer.parseInt(ifconfigparts[2]);
                this.mOpenVPNService.setLocalIP(ifconfigparts[0], ifconfigparts[1], mtu, ifconfigparts[3]);
                break;
            }
            case "PERSIST_TUN_ACTION": {
                status = this.mOpenVPNService.getTunReopenStatus();
                break;
            }
            case "OPENTUN": {
                if (this.sendTunFD(needed, extra)) {
                    return;
                }
                status = "cancel";
                break;
            }
            default: {
                Log.e((String)TAG, (String)("Unknown needok command " + argument));
                return;
            }
        }
        String cmd = String.format("needok '%s' %s\n", needed, status);
        this.managmentCommand(cmd);
    }

    private boolean sendTunFD(String needed, String extra) {
        if (!extra.equals("tun")) {
            VpnStatus.logError(String.format("Device type %s requested, but only tun is possible with the Android API, sorry!", extra));
            return false;
        }
        ParcelFileDescriptor pfd = this.mOpenVPNService.openTun();
        if (pfd == null) {
            return false;
        }
        int fdint = pfd.getFd();
        try {
            Method setInt = FileDescriptor.class.getDeclaredMethod("setInt$", Integer.TYPE);
            FileDescriptor fdtosend = new FileDescriptor();
            setInt.invoke((Object)fdtosend, fdint);
            FileDescriptor[] fds = new FileDescriptor[]{fdtosend};
            this.mSocket.setFileDescriptorsForSend(fds);
            String cmd = String.format("needok '%s' %s\n", needed, "ok");
            this.managmentCommand(cmd);
            this.mSocket.setFileDescriptorsForSend(null);
            pfd.close();
            return true;
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException exp) {
            VpnStatus.logException("Could not send fd over socket", exp);
            return false;
        }
    }

    private void processPWCommand(String argument) {
        String needed;
        try {
            int p1 = argument.indexOf(39);
            int p2 = argument.indexOf(39, p1 + 1);
            needed = argument.substring(p1 + 1, p2);
            if (argument.startsWith("Verification Failed")) {
                this.proccessPWFailed(needed, argument.substring(p2 + 1));
                return;
            }
        }
        catch (StringIndexOutOfBoundsException sioob) {
            VpnStatus.logError("Could not parse management Password command: " + argument);
            return;
        }
        String pw = null;
        if (needed.equals("Private Key")) {
            pw = this.mProfile.getPasswordPrivateKey();
        } else if (needed.equals("Auth")) {
            String usercmd = String.format("username '%s' %s\n", needed, VpnProfile.openVpnEscape(this.mProfile.mUsername));
            this.managmentCommand(usercmd);
            pw = this.mProfile.getPasswordAuth();
        }
        if (pw != null) {
            String cmd = String.format("password '%s' %s\n", needed, VpnProfile.openVpnEscape(pw));
            this.managmentCommand(cmd);
        } else {
            VpnStatus.logError(String.format("Fastestvpn requires Authentication type '%s' but no password/key information available", needed));
        }
    }

    private void proccessPWFailed(String needed, String args) {
        VpnStatus.updateStateString("AUTH_FAILED", needed + args, R.string.state_auth_failed, VpnStatus.ConnectionStatus.LEVEL_AUTH_FAILED);
    }

    @Override
    public void networkChange(boolean samenetwork) {
        if (this.mWaitingForRelease) {
            this.releaseHold();
        } else if (samenetwork) {
            this.managmentCommand("network-change samenetwork\n");
        } else {
            this.managmentCommand("network-change\n");
        }
    }

    @Override
    public void setPauseCallback(OpenVPNManagement.PausedStateCallback callback) {
        this.mPauseCallback = callback;
    }

    public void signalusr1() {
        this.mResumeHandler.removeCallbacks(this.mResumeHoldRunnable);
        if (!this.mWaitingForRelease) {
            this.managmentCommand("signal SIGUSR1\n");
        } else {
            VpnStatus.updateStatePause(this.lastPauseReason);
        }
    }

    @Override
    public void reconnect() {
        this.signalusr1();
        this.releaseHold();
    }

    private void processSignCommand(String b64data) {
        String signed_string = this.mProfile.getSignedData(b64data);
        if (signed_string == null) {
            this.managmentCommand("rsa-sig\n");
            this.managmentCommand("\nEND\n");
            OpenVpnManagementThread.stopOpenVPN();
            return;
        }
        this.managmentCommand("rsa-sig\n");
        this.managmentCommand(signed_string);
        this.managmentCommand("\nEND\n");
    }

    @Override
    public void pause(OpenVPNManagement.pauseReason reason) {
        this.lastPauseReason = reason;
        this.signalusr1();
    }

    @Override
    public void resume() {
        this.releaseHold();
        this.lastPauseReason = OpenVPNManagement.pauseReason.noNetwork;
    }

    @Override
    public boolean stopVPN(boolean replaceConnection) {
        boolean stopSucceed = OpenVpnManagementThread.stopOpenVPN();
        if (stopSucceed) {
            this.mShuttingDown = true;
        }
        Log.i((String)"stopVPN", (String)"done method call");
        return stopSucceed;
    }
}

