/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.VpnService;
import android.os.Bundle;
import android.os.RemoteException;
import de.blinkt.openvpn.OpenVpnApi;

public class VpnAuthActivity
extends Activity {
    public static final String KEY_CONFIG = "config";
    public static final String KEY_USERNAME = "username";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_COUNTRY = "country";
    public static final String KEY_PORT = "port";
    public static final String KEY_DNS = "dns";
    private String mConfig;
    private String mUsername;
    private String mPw;
    private String mCountry;
    private String mServerPort;
    private String mDNS1;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mConfig = this.getIntent().getStringExtra(KEY_CONFIG);
        this.mUsername = this.getIntent().getStringExtra(KEY_USERNAME);
        this.mPw = this.getIntent().getStringExtra(KEY_PASSWORD);
        this.mCountry = this.getIntent().getStringExtra(KEY_COUNTRY);
        this.mServerPort = this.getIntent().getStringExtra(KEY_PORT);
        this.mDNS1 = this.getIntent().getStringExtra(KEY_DNS);
        Intent intent = VpnService.prepare((Context)this);
        if (intent != null) {
            this.startActivityForResult(intent, 0);
        } else {
            this.startVpn();
            this.finish();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            this.startVpn();
        }
        this.finish();
    }

    private void startVpn() {
        try {
            OpenVpnApi.startVpnInternal((Context)this, this.mConfig, this.mUsername, this.mPw, this.mCountry, this.mServerPort, this.mDNS1);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }
}

