/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.preference.PreferenceManager;
import android.security.KeyChain;
import android.security.KeyChainException;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Base64;
import de.blinkt.openvpn.R;
import de.blinkt.openvpn.core.Connection;
import de.blinkt.openvpn.core.NativeUtils;
import de.blinkt.openvpn.core.OpenVPNService;
import de.blinkt.openvpn.core.VPNLaunchHelper;
import de.blinkt.openvpn.core.VpnStatus;
import de.blinkt.openvpn.core.X509Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import java.util.Vector;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.spongycastle.util.io.pem.PemObject;
import org.spongycastle.util.io.pem.PemWriter;

public class VpnProfile
implements Serializable,
Cloneable {
    public static final String EXTRA_PROFILEUUID = "de.blinkt.openvpn.profileUUID";
    public static final transient long MAX_EMBED_FILE_SIZE = 0x200000L;
    public static final String INLINE_TAG = "[[INLINE]]";
    public static final String DISPLAYNAME_TAG = "[[NAME]]";
    private static final int MAXLOGLEVEL = 4;
    private static final int CURRENT_PROFILE_VERSION = 6;
    public static final int TYPE_CERTIFICATES = 0;
    private static final int TYPE_PKCS12 = 1;
    public static final int TYPE_KEYSTORE = 2;
    public static final int TYPE_USERPASS = 3;
    public static final int TYPE_STATICKEYS = 4;
    public static final int TYPE_USERPASS_CERTIFICATES = 5;
    private static final int TYPE_USERPASS_PKCS12 = 6;
    public static final int TYPE_USERPASS_KEYSTORE = 7;
    public static final int X509_VERIFY_TLSREMOTE = 0;
    public static final int X509_VERIFY_TLSREMOTE_COMPAT_NOREMAPPING = 1;
    public static final int X509_VERIFY_TLSREMOTE_DN = 2;
    public static final int X509_VERIFY_TLSREMOTE_RDN = 3;
    public static final int X509_VERIFY_TLSREMOTE_RDN_PREFIX = 4;
    private static final boolean mIsOpenVPN22 = false;
    private static final long serialVersionUID = 7085688938959334563L;
    public static String DEFAULT_DNS1 = "8.8.8.8";
    private static String DEFAULT_DNS2 = "8.8.4.4";
    private transient String mTransientPW = null;
    private transient String mTransientPCKS12PW = null;
    public int mAuthenticationType = 2;
    public String mName;
    private String mAlias;
    public String mClientCertFilename;
    public String mTLSAuthDirection = "";
    public String mTLSAuthFilename;
    public String mClientKeyFilename;
    public String mCaFilename;
    public boolean mUseLzo = true;
    public String mPKCS12Filename;
    private String mPKCS12Password;
    public boolean mUseTLSAuth = false;
    public String mDNS1 = DEFAULT_DNS1;
    public String mDNS2 = DEFAULT_DNS2;
    public String mIPv4Address;
    private String mIPv6Address;
    public boolean mOverrideDNS = false;
    public String mSearchDomain = "blinkt.de";
    public boolean mUseDefaultRoute = true;
    public boolean mUsePull = true;
    public String mCustomRoutes;
    public boolean mCheckRemoteCN = true;
    public boolean mExpectTLSCert = false;
    public String mRemoteCN = "";
    public String mPassword = "";
    public String mUsername = "";
    public boolean mRoutenopull = false;
    public boolean mUseRandomHostname = false;
    public boolean mUseFloat = false;
    public boolean mUseCustomConfig = false;
    public String mCustomConfigOptions = "";
    public String mVerb = "1";
    public String mCipher = "";
    public boolean mNobind = false;
    private boolean mUseDefaultRoutev6 = false;
    public String mCustomRoutesv6 = "";
    private String mKeyPassword = "";
    public boolean mPersistTun = false;
    public String mConnectRetryMax = "-1";
    public String mConnectRetry = "2";
    public String mConnectRetryMaxTime = "300";
    private boolean mUserEditable = true;
    public String mAuth = "";
    public int mX509AuthType = 3;
    public String mx509UsernameField = null;
    public boolean mAllowLocalLAN;
    public String mExcludedRoutes;
    public int mMssFix = 0;
    public Connection[] mConnections = new Connection[0];
    public boolean mRemoteRandom = false;
    public HashSet<String> mAllowedAppsVpn = new HashSet();
    public boolean mAllowedAppsVpnAreDisallowed = true;
    public String mCrlFilename;
    String mProfileCreator;
    public boolean mPushPeerInfo = false;
    public String mServerName = "openvpn.blinkt.de";
    public String mServerPort = "1194";
    private transient PrivateKey mPrivateKey;
    private UUID mUuid = UUID.randomUUID();
    private int mProfileVersion;

    public VpnProfile(String name) {
        this.mName = name;
        this.mProfileVersion = 6;
        this.mConnections = new Connection[1];
        this.mConnections[0] = new Connection();
    }

    public static String openVpnEscape(String unescaped) {
        if (unescaped == null) {
            return null;
        }
        String escapedString = unescaped.replace("\\", "\\\\");
        escapedString = escapedString.replace("\"", "\\\"");
        if (!(!(escapedString = escapedString.replace("\n", "\\n")).equals(unescaped) || escapedString.contains(" ") || escapedString.contains("#") || escapedString.contains(";") || escapedString.equals(""))) {
            return unescaped;
        }
        return '\"' + escapedString + '\"';
    }

    public static String insertFileData(String cfgentry, String filedata) {
        if (filedata == null) {
            return String.format("%s %s\n", cfgentry, "file missing in config profile");
        }
        if (VpnProfile.isEmbedded(filedata)) {
            String dataWithOutHeader = VpnProfile.getEmbeddedContent(filedata);
            return String.format(Locale.ENGLISH, "<%s>\n%s\n</%s>\n", cfgentry, dataWithOutHeader, cfgentry);
        }
        return String.format(Locale.ENGLISH, "%s %s\n", cfgentry, VpnProfile.openVpnEscape(filedata));
    }

    public static String getDisplayName(String embeddedFile) {
        int start = DISPLAYNAME_TAG.length();
        int end = embeddedFile.indexOf(INLINE_TAG);
        return embeddedFile.substring(start, end);
    }

    public static String getEmbeddedContent(String data) {
        if (!data.contains(INLINE_TAG)) {
            return data;
        }
        int start = data.indexOf(INLINE_TAG) + INLINE_TAG.length();
        return data.substring(start);
    }

    public static boolean isEmbedded(String data) {
        return data != null && (data.startsWith(INLINE_TAG) || data.startsWith(DISPLAYNAME_TAG));
    }

    public void clearDefaults() {
        this.mServerName = "unknown";
        this.mUsePull = false;
        this.mUseLzo = false;
        this.mUseDefaultRoute = false;
        this.mUseDefaultRoutev6 = false;
        this.mExpectTLSCert = false;
        this.mCheckRemoteCN = false;
        this.mPersistTun = false;
        this.mAllowLocalLAN = true;
        this.mPushPeerInfo = false;
        this.mMssFix = 0;
    }

    public UUID getUUID() {
        return this.mUuid;
    }

    public String getName() {
        if (this.mName == null) {
            return "No profile name";
        }
        return this.mName;
    }

    public void upgradeProfile() {
        if (this.mProfileVersion < 2) {
            boolean bl = this.mAllowLocalLAN = Build.VERSION.SDK_INT < 19;
        }
        if (this.mProfileVersion < 4) {
            this.moveOptionsToConnection();
            this.mAllowedAppsVpnAreDisallowed = true;
        }
        if (this.mAllowedAppsVpn == null) {
            this.mAllowedAppsVpn = new HashSet();
        }
        if (this.mConnections == null) {
            this.mConnections = new Connection[0];
        }
        if (this.mProfileVersion < 6 && TextUtils.isEmpty((CharSequence)this.mProfileCreator)) {
            this.mUserEditable = true;
        }
        this.mProfileVersion = 6;
    }

    private void moveOptionsToConnection() {
        this.mConnections = new Connection[1];
        Connection conn = new Connection();
        conn.mServerName = this.mServerName;
        conn.mServerPort = this.mServerPort;
        conn.mUseUdp = true;
        conn.mCustomConfiguration = "";
        this.mConnections[0] = conn;
    }

    private String getConfigFile(Context context, boolean configForOvpn3) {
        SharedPreferences prefs;
        boolean usesystemproxy;
        boolean useTLSClient;
        File cacheDir = context.getCacheDir();
        String cfg = "";
        cfg = cfg + "# Enables connection to GUI\n";
        cfg = cfg + "management ";
        cfg = cfg + cacheDir.getAbsolutePath() + "/mgmtsocket";
        cfg = cfg + " unix\n";
        cfg = cfg + "management-client\n";
        cfg = cfg + "management-query-passwords\n";
        cfg = cfg + "management-hold\n\n";
        if (!configForOvpn3) {
            cfg = cfg + String.format("setenv IV_GUI_VER %s \n", VpnProfile.openVpnEscape(this.getVersionEnvString(context)));
            String versionString = String.format(Locale.US, "%d %s %s %s %s %s", Build.VERSION.SDK_INT, Build.VERSION.RELEASE, NativeUtils.getNativeAPI(), Build.BRAND, Build.BOARD, Build.MODEL);
            cfg = cfg + String.format("setenv IV_PLAT_VER %s\n", VpnProfile.openVpnEscape(versionString));
        }
        cfg = cfg + "machine-readable-output\n";
        cfg = cfg + "ifconfig-nowarn\n";
        boolean bl = useTLSClient = this.mAuthenticationType != 4;
        if (useTLSClient && this.mUsePull) {
            cfg = cfg + "client\n";
        } else if (this.mUsePull) {
            cfg = cfg + "pull\n";
        } else if (useTLSClient) {
            cfg = cfg + "tls-client\n";
        }
        cfg = cfg + "verb 4\n";
        if (this.mConnectRetryMax == null) {
            this.mConnectRetryMax = "-1";
        }
        if (!this.mConnectRetryMax.equals("-1")) {
            cfg = cfg + "connect-retry-max " + this.mConnectRetryMax + "\n";
        }
        if (TextUtils.isEmpty((CharSequence)this.mConnectRetry)) {
            this.mConnectRetry = "2";
        }
        if (TextUtils.isEmpty((CharSequence)this.mConnectRetryMaxTime)) {
            this.mConnectRetryMaxTime = "300";
        }
        boolean mUseUdp = true;
        cfg = cfg + "connect-retry " + this.mConnectRetry + " " + this.mConnectRetryMaxTime + "\n";
        cfg = cfg + "resolv-retry 60\n";
        cfg = cfg + "dev tun\n";
        boolean canUsePlainRemotes = true;
        if (this.mConnections.length == 1) {
            cfg = cfg + this.mConnections[0].getConnectionBlock();
        } else {
            for (Connection conn : this.mConnections) {
                canUsePlainRemotes = canUsePlainRemotes && conn.isOnlyRemote();
            }
            if (this.mRemoteRandom) {
                cfg = cfg + "remote-random\n";
            }
            if (canUsePlainRemotes) {
                for (Connection conn : this.mConnections) {
                    if (!conn.mEnabled) continue;
                    cfg = cfg + conn.getConnectionBlock();
                }
            }
        }
        switch (this.mAuthenticationType) {
            case 5: {
                cfg = cfg + "auth-user-pass\n";
            }
            case 0: {
                cfg = cfg + VpnProfile.insertFileData("ca", this.mCaFilename);
                cfg = cfg + VpnProfile.insertFileData("key", this.mClientKeyFilename);
                cfg = cfg + VpnProfile.insertFileData("cert", this.mClientCertFilename);
                break;
            }
            case 6: {
                cfg = cfg + "auth-user-pass\n";
            }
            case 1: {
                cfg = cfg + VpnProfile.insertFileData("pkcs12", this.mPKCS12Filename);
                break;
            }
            case 7: {
                cfg = cfg + "auth-user-pass\n";
            }
            case 2: {
                if (configForOvpn3) break;
                String[] ks = this.getKeyStoreCertificates(context);
                cfg = cfg + "### From Keystore ####\n";
                if (ks != null) {
                    cfg = cfg + "<ca>\n" + ks[0] + "\n</ca>\n";
                    if (ks[1] != null) {
                        cfg = cfg + "<extra-certs>\n" + ks[1] + "\n</extra-certs>\n";
                    }
                    cfg = cfg + "<cert>\n" + ks[2] + "\n</cert>\n";
                    cfg = cfg + "management-external-key\n";
                    break;
                }
                cfg = cfg + context.getString(R.string.keychain_access) + "\n";
                if (Build.VERSION.SDK_INT != 16 || this.mAlias.matches("^[a-zA-Z0-9]$")) break;
                cfg = cfg + context.getString(R.string.jelly_keystore_alphanumeric_bug) + "\n";
                break;
            }
            case 3: {
                cfg = cfg + "auth-user-pass\n";
                cfg = cfg + VpnProfile.insertFileData("ca", this.mCaFilename);
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCrlFilename)) {
            cfg = cfg + VpnProfile.insertFileData("crl-verify", this.mCrlFilename);
        }
        if (this.mUseLzo) {
            cfg = cfg + "comp-lzo\n";
        }
        if (this.mUseTLSAuth) {
            cfg = this.mAuthenticationType == 4 ? cfg + VpnProfile.insertFileData("secret", this.mTLSAuthFilename) : cfg + VpnProfile.insertFileData("tls-auth", this.mTLSAuthFilename);
            if (!TextUtils.isEmpty((CharSequence)this.mTLSAuthDirection)) {
                cfg = cfg + "key-direction ";
                cfg = cfg + this.mTLSAuthDirection;
                cfg = cfg + "\n";
            }
        }
        if (!this.mUsePull && !TextUtils.isEmpty((CharSequence)this.mIPv4Address)) {
            cfg = cfg + "ifconfig " + this.cidrToIPAndNetmask(this.mIPv4Address) + "\n";
        }
        if (this.mUsePull && this.mRoutenopull) {
            cfg = cfg + "route-nopull\n";
        }
        String routes = "";
        if (this.mUseDefaultRoute) {
            routes = routes + "route 0.0.0.0 0.0.0.0 vpn_gateway\n";
        } else {
            for (String route : this.getCustomRoutes(this.mCustomRoutes)) {
                routes = routes + "route " + route + " vpn_gateway\n";
            }
            for (String route : this.getCustomRoutes(this.mExcludedRoutes)) {
                routes = routes + "route " + route + " net_gateway\n";
            }
        }
        cfg = cfg + routes;
        if (this.mOverrideDNS || !this.mUsePull) {
            if (!TextUtils.isEmpty((CharSequence)this.mDNS1)) {
                cfg = cfg + "dhcp-option DNS " + this.mDNS1 + "\n";
            }
            if (!TextUtils.isEmpty((CharSequence)this.mDNS2)) {
                cfg = cfg + "dhcp-option DNS " + this.mDNS2 + "\n";
            }
            if (!TextUtils.isEmpty((CharSequence)this.mSearchDomain)) {
                cfg = cfg + "dhcp-option DOMAIN " + this.mSearchDomain + "\n";
            }
        }
        if (this.mMssFix != 0) {
            cfg = this.mMssFix != 1450 ? cfg + String.format(Locale.US, "mssfix %d\n", this.mMssFix) : cfg + "mssfix\n";
        }
        if (this.mNobind) {
            cfg = cfg + "nobind\n";
        }
        if (this.mAuthenticationType != 4) {
            if (this.mCheckRemoteCN) {
                if (this.mRemoteCN == null || this.mRemoteCN.equals("")) {
                    cfg = cfg + "verify-x509-name " + VpnProfile.openVpnEscape(this.mConnections[0].mServerName) + " name\n";
                } else {
                    switch (this.mX509AuthType) {
                        case 1: {
                            cfg = cfg + "compat-names no-remapping\n";
                        }
                        case 0: {
                            cfg = cfg + "tls-remote " + VpnProfile.openVpnEscape(this.mRemoteCN) + "\n";
                            break;
                        }
                        case 3: {
                            cfg = cfg + "verify-x509-name " + VpnProfile.openVpnEscape(this.mRemoteCN) + " name\n";
                            break;
                        }
                        case 4: {
                            cfg = cfg + "verify-x509-name " + VpnProfile.openVpnEscape(this.mRemoteCN) + " name-prefix\n";
                            break;
                        }
                        case 2: {
                            cfg = cfg + "verify-x509-name " + VpnProfile.openVpnEscape(this.mRemoteCN) + "\n";
                        }
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)this.mx509UsernameField)) {
                    cfg = cfg + "x509-username-field " + VpnProfile.openVpnEscape(this.mx509UsernameField) + "\n";
                }
            }
            if (this.mExpectTLSCert) {
                cfg = cfg + "remote-cert-tls server\n";
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCipher)) {
            cfg = cfg + "cipher " + this.mCipher + "\n";
        }
        if (!TextUtils.isEmpty((CharSequence)this.mAuth)) {
            cfg = cfg + "auth " + this.mAuth + "\n";
        }
        if (this.mUseRandomHostname) {
            cfg = cfg + "#my favorite options :)\nremote-random-hostname\n";
        }
        if (this.mUseFloat) {
            cfg = cfg + "float\n";
        }
        if (this.mPersistTun) {
            cfg = cfg + "persist-tun\n";
            cfg = cfg + "# persist-tun also enables pre resolving to avoid DNS resolve problem\n";
            cfg = cfg + "preresolve\n";
        }
        if (this.mPushPeerInfo) {
            cfg = cfg + "push-peer-info\n";
        }
        if (usesystemproxy = (prefs = PreferenceManager.getDefaultSharedPreferences((Context)context)).getBoolean("usesystemproxy", true)) {
            cfg = cfg + "# Use system proxy setting\n";
            cfg = cfg + "management-query-proxy\n";
        }
        if (this.mUseCustomConfig) {
            cfg = cfg + "# Custom configuration options\n";
            cfg = cfg + "# You are on your on own here :)\n";
            cfg = cfg + this.mCustomConfigOptions;
            cfg = cfg + "\n";
        }
        if (!canUsePlainRemotes) {
            cfg = cfg + "# Connection Options are at the end to allow global options (and global custom options) to influence connection blocks\n";
            for (Connection conn : this.mConnections) {
                if (!conn.mEnabled) continue;
                cfg = cfg + "<connection>\n";
                cfg = cfg + conn.getConnectionBlock();
                cfg = cfg + "</connection>\n";
            }
        }
        return cfg;
    }

    private String getVersionEnvString(Context c) {
        String version = "unknown";
        try {
            PackageInfo packageinfo = c.getPackageManager().getPackageInfo(c.getPackageName(), 0);
            version = packageinfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            VpnStatus.logException((Exception)((Object)e));
        }
        return String.format(Locale.US, "%s %s", c.getPackageName(), version);
    }

    @NonNull
    private Collection<String> getCustomRoutes(String routes) {
        Vector<String> cidrRoutes = new Vector<String>();
        if (routes == null) {
            return cidrRoutes;
        }
        for (String route : routes.split("[\n \t]")) {
            if (route.equals("")) continue;
            String cidrroute = this.cidrToIPAndNetmask(route);
            if (cidrroute == null) {
                return cidrRoutes;
            }
            cidrRoutes.add(cidrroute);
        }
        return cidrRoutes;
    }

    private Collection<String> getCustomRoutesv6(String routes) {
        Vector<String> cidrRoutes = new Vector<String>();
        if (routes == null) {
            return cidrRoutes;
        }
        for (String route : routes.split("[\n \t]")) {
            if (route.equals("")) continue;
            cidrRoutes.add(route);
        }
        return cidrRoutes;
    }

    private String cidrToIPAndNetmask(String route) {
        int len;
        String[] parts = route.split("/");
        if (parts.length == 1) {
            parts = (route + "/32").split("/");
        }
        if (parts.length != 2) {
            return null;
        }
        try {
            len = Integer.parseInt(parts[1]);
        }
        catch (NumberFormatException ne) {
            return null;
        }
        if (len < 0 || len > 32) {
            return null;
        }
        long nm = 0xFFFFFFFFL;
        nm = nm << 32 - len & 0xFFFFFFFFL;
        String netmask = String.format(Locale.ENGLISH, "%d.%d.%d.%d", (nm & 0xFFFFFFFFFF000000L) >> 24, (nm & 0xFF0000L) >> 16, (nm & 0xFF00L) >> 8, nm & 0xFFL);
        return parts[0] + "  " + netmask;
    }

    public Intent prepareStartService(Context context) {
        Intent intent = this.getStartServiceIntent(context);
        return intent;
    }

    public void writeConfigFile(Context context) throws IOException {
        FileWriter cfg = new FileWriter(VPNLaunchHelper.getConfigFilePath(context));
        cfg.write(this.getConfigFile(context, false));
        cfg.flush();
        cfg.close();
    }

    public Intent getStartServiceIntent(Context context) {
        String prefix = context.getPackageName();
        Intent intent = new Intent(context, OpenVPNService.class);
        intent.putExtra(prefix + ".profileUUID", this.mUuid.toString());
        return intent;
    }

    private String[] getKeyStoreCertificates(Context context) {
        return this.getKeyStoreCertificates(context, 5);
    }

    public void checkForRestart(final Context context) {
        if ((this.mAuthenticationType == 2 || this.mAuthenticationType == 7) && this.mPrivateKey == null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    VpnProfile.this.getKeyStoreCertificates(context);
                }
            }).start();
        }
    }

    protected VpnProfile clone() throws CloneNotSupportedException {
        VpnProfile copy = (VpnProfile)super.clone();
        copy.mUuid = UUID.randomUUID();
        copy.mConnections = new Connection[this.mConnections.length];
        int i = 0;
        for (Connection conn : this.mConnections) {
            copy.mConnections[i++] = conn.clone();
        }
        copy.mAllowedAppsVpn = (HashSet)this.mAllowedAppsVpn.clone();
        return copy;
    }

    public VpnProfile copy(String name) {
        try {
            VpnProfile copy = this.clone();
            copy.mName = name;
            return copy;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private synchronized String[] getKeyStoreCertificates(Context context, int tries) {
        context = context.getApplicationContext();
        try {
            String extra;
            String ca;
            this.mPrivateKey = KeyChain.getPrivateKey((Context)context, (String)this.mAlias);
            String keystoreChain = null;
            X509Certificate[] caChain = KeyChain.getCertificateChain((Context)context, (String)this.mAlias);
            if (caChain == null) {
                throw new NoCertReturnedException("No certificate returned from Keystore");
            }
            if (caChain.length <= 1 && TextUtils.isEmpty((CharSequence)this.mCaFilename)) {
                VpnStatus.logMessage(VpnStatus.LogLevel.ERROR, "", context.getString(R.string.keychain_nocacert));
            } else {
                StringWriter ksStringWriter = new StringWriter();
                PemWriter pw = new PemWriter(ksStringWriter);
                for (int i = 1; i < caChain.length; ++i) {
                    X509Certificate cert = caChain[i];
                    pw.writeObject(new PemObject("CERTIFICATE", cert.getEncoded()));
                }
                pw.close();
                keystoreChain = ksStringWriter.toString();
            }
            String caout = null;
            if (!TextUtils.isEmpty((CharSequence)this.mCaFilename)) {
                try {
                    Certificate[] cacerts = X509Utils.getCertificatesFromFile(this.mCaFilename);
                    StringWriter caoutWriter = new StringWriter();
                    PemWriter pw = new PemWriter(caoutWriter);
                    for (Certificate cert : cacerts) {
                        pw.writeObject(new PemObject("CERTIFICATE", cert.getEncoded()));
                    }
                    pw.close();
                    caout = caoutWriter.toString();
                }
                catch (Exception e) {
                    VpnStatus.logError("Could not read CA certificate" + e.getLocalizedMessage());
                }
            }
            StringWriter certout = new StringWriter();
            if (caChain.length >= 1) {
                X509Certificate usercert = caChain[0];
                PemWriter upw = new PemWriter(certout);
                upw.writeObject(new PemObject("CERTIFICATE", usercert.getEncoded()));
                upw.close();
            }
            String user = certout.toString();
            if (caout == null) {
                ca = keystoreChain;
                extra = null;
            } else {
                ca = caout;
                extra = keystoreChain;
            }
            return new String[]{ca, extra, user};
        }
        catch (KeyChainException | NoCertReturnedException | IOException | IllegalArgumentException | InterruptedException | CertificateException e) {
            e.printStackTrace();
            VpnStatus.logError(R.string.keyChainAccessError, e.getLocalizedMessage());
            VpnStatus.logError(R.string.keychain_access);
            if (Build.VERSION.SDK_INT == 16 && !this.mAlias.matches("^[a-zA-Z0-9]$")) {
                VpnStatus.logError(R.string.jelly_keystore_alphanumeric_bug);
            }
            return null;
        }
        catch (AssertionError e) {
            if (tries == 0) {
                return null;
            }
            VpnStatus.logError(String.format("Failure getting Keystore Keys (%s), retrying", ((Throwable)((Object)e)).getLocalizedMessage()));
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e1) {
                VpnStatus.logException(e1);
            }
            return this.getKeyStoreCertificates(context, tries - 1);
        }
    }

    int checkProfile(Context context) {
        if ((this.mAuthenticationType == 2 || this.mAuthenticationType == 7) && this.mAlias == null) {
            return R.string.no_keystore_cert_selected;
        }
        if (!(this.mUsePull && this.mAuthenticationType != 4 || this.mIPv4Address != null && this.cidrToIPAndNetmask(this.mIPv4Address) != null)) {
            return R.string.ipv4_format_error;
        }
        if (!this.mUseDefaultRoute) {
            if (!TextUtils.isEmpty((CharSequence)this.mCustomRoutes) && this.getCustomRoutes(this.mCustomRoutes).size() == 0) {
                return R.string.custom_route_format_error;
            }
            if (!TextUtils.isEmpty((CharSequence)this.mExcludedRoutes) && this.getCustomRoutes(this.mExcludedRoutes).size() == 0) {
                return R.string.custom_route_format_error;
            }
        }
        if (this.mUseTLSAuth && TextUtils.isEmpty((CharSequence)this.mTLSAuthFilename)) {
            return R.string.missing_tlsauth;
        }
        if ((this.mAuthenticationType == 5 || this.mAuthenticationType == 0) && (TextUtils.isEmpty((CharSequence)this.mClientCertFilename) || TextUtils.isEmpty((CharSequence)this.mClientKeyFilename))) {
            return R.string.missing_certificates;
        }
        if ((this.mAuthenticationType == 0 || this.mAuthenticationType == 5) && TextUtils.isEmpty((CharSequence)this.mCaFilename)) {
            return R.string.missing_ca_certificate;
        }
        boolean noRemoteEnabled = true;
        for (Connection c : this.mConnections) {
            if (!c.mEnabled) continue;
            noRemoteEnabled = false;
        }
        if (noRemoteEnabled) {
            return R.string.remote_no_server_selected;
        }
        return R.string.no_error_found;
    }

    public String getPasswordPrivateKey() {
        if (this.mTransientPCKS12PW != null) {
            String pwcopy = this.mTransientPCKS12PW;
            this.mTransientPCKS12PW = null;
            return pwcopy;
        }
        switch (this.mAuthenticationType) {
            case 1: 
            case 6: {
                return this.mPKCS12Password;
            }
            case 0: 
            case 5: {
                return this.mKeyPassword;
            }
        }
        return null;
    }

    private boolean isUserPWAuth() {
        switch (this.mAuthenticationType) {
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    private boolean requireTLSKeyPassword() {
        if (TextUtils.isEmpty((CharSequence)this.mClientKeyFilename)) {
            return false;
        }
        String data = "";
        if (VpnProfile.isEmbedded(this.mClientKeyFilename)) {
            data = this.mClientKeyFilename;
        } else {
            char[] buf = new char[2048];
            try {
                FileReader fr = new FileReader(this.mClientKeyFilename);
                int len = fr.read(buf);
                while (len > 0) {
                    data = data + new String(buf, 0, len);
                    len = fr.read(buf);
                }
                fr.close();
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
        return data.contains("Proc-Type: 4,ENCRYPTED") || data.contains("-----BEGIN ENCRYPTED PRIVATE KEY-----");
    }

    public int needUserPWInput(boolean ignoreTransient) {
        if (!(this.mAuthenticationType != 1 && this.mAuthenticationType != 6 || this.mPKCS12Password != null && !this.mPKCS12Password.equals("") || !ignoreTransient && this.mTransientPCKS12PW != null)) {
            return R.string.pkcs12_file_encryption_key;
        }
        if ((this.mAuthenticationType == 0 || this.mAuthenticationType == 5) && this.requireTLSKeyPassword() && TextUtils.isEmpty((CharSequence)this.mKeyPassword) && (ignoreTransient || this.mTransientPCKS12PW == null)) {
            return R.string.private_key_password;
        }
        if (this.isUserPWAuth() && (TextUtils.isEmpty((CharSequence)this.mUsername) || TextUtils.isEmpty((CharSequence)this.mPassword) && (this.mTransientPW == null || ignoreTransient))) {
            return R.string.password;
        }
        return 0;
    }

    public String getPasswordAuth() {
        if (this.mTransientPW != null) {
            String pwcopy = this.mTransientPW;
            this.mTransientPW = null;
            return pwcopy;
        }
        return this.mPassword;
    }

    public String toString() {
        return this.mName;
    }

    public String getUUIDString() {
        return this.mUuid.toString();
    }

    private PrivateKey getKeystoreKey() {
        return this.mPrivateKey;
    }

    public String getSignedData(String b64data) {
        PrivateKey privkey = this.getKeystoreKey();
        byte[] data = Base64.decode((String)b64data, (int)0);
        if (Build.VERSION.SDK_INT == 16) {
            return this.processSignJellyBeans(privkey, data);
        }
        try {
            Cipher rsaSigner = Cipher.getInstance("RSA/ECB/PKCS1PADDING");
            rsaSigner.init(1, privkey);
            byte[] signed_bytes = rsaSigner.doFinal(data);
            return Base64.encodeToString((byte[])signed_bytes, (int)2);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            VpnStatus.logError(R.string.error_rsa_sign, e.getClass().toString(), e.getLocalizedMessage());
            return null;
        }
    }

    private String processSignJellyBeans(PrivateKey privkey, byte[] data) {
        try {
            Method getKey = privkey.getClass().getSuperclass().getDeclaredMethod("getOpenSSLKey", new Class[0]);
            getKey.setAccessible(true);
            Object opensslkey = getKey.invoke((Object)privkey, new Object[0]);
            getKey.setAccessible(false);
            Method getPkeyContext = opensslkey.getClass().getDeclaredMethod("getPkeyContext", new Class[0]);
            getPkeyContext.setAccessible(true);
            int pkey = (Integer)getPkeyContext.invoke(opensslkey, new Object[0]);
            getPkeyContext.setAccessible(false);
            byte[] signed_bytes = NativeUtils.rsasign(data, pkey);
            return Base64.encodeToString((byte[])signed_bytes, (int)2);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException | InvalidKeyException e) {
            VpnStatus.logError(R.string.error_rsa_sign, e.getClass().toString(), e.getLocalizedMessage());
            return null;
        }
    }

    private class NoCertReturnedException
    extends Exception {
        NoCertReturnedException(String msg) {
            super(msg);
        }
    }
}

