/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn.core;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.UiModeManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.net.VpnService;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.preference.PreferenceManager;
import android.support.v4.content.LocalBroadcastManager;
import android.system.OsConstants;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import de.blinkt.openvpn.DisconnectVPNActivity;
import de.blinkt.openvpn.R;
import de.blinkt.openvpn.VpnProfile;
import de.blinkt.openvpn.core.CIDRIP;
import de.blinkt.openvpn.core.DeviceStateReceiver;
import de.blinkt.openvpn.core.NativeUtils;
import de.blinkt.openvpn.core.NetworkSpace;
import de.blinkt.openvpn.core.OpenVPNManagement;
import de.blinkt.openvpn.core.OpenVPNThread;
import de.blinkt.openvpn.core.OpenVpnManagementThread;
import de.blinkt.openvpn.core.ProfileManager;
import de.blinkt.openvpn.core.VPNLaunchHelper;
import de.blinkt.openvpn.core.VpnStatus;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Locale;
import java.util.Vector;

public class OpenVPNService
extends VpnService
implements VpnStatus.StateListener,
Handler.Callback,
VpnStatus.ByteCountListener {
    public static final String TAG = OpenVPNService.class.getName();
    public static final String START_SERVICE = "de.blinkt.openvpn.START_SERVICE";
    public static final String START_SERVICE_STICKY = "de.blinkt.openvpn.START_SERVICE_STICKY";
    public static final String ALWAYS_SHOW_NOTIFICATION = "de.blinkt.openvpn.NOTIFICATION_ALWAYS_VISIBLE";
    public static final String DISCONNECT_VPN = "de.blinkt.openvpn.DISCONNECT_VPN";
    private static final String PAUSE_VPN = "de.blinkt.openvpn.PAUSE_VPN";
    private static final String RESUME_VPN = "de.blinkt.openvpn.RESUME_VPN";
    private static final int OPENVPN_STATUS = 1;
    private static boolean mNotificationAlwaysVisible = false;
    private static Class mNotificationActivityClass;
    private final Vector<String> mDnslist = new Vector();
    private final NetworkSpace mRoutes = new NetworkSpace();
    private final NetworkSpace mRoutesv6 = new NetworkSpace();
    private final IBinder mBinder = new LocalBinder();
    private final Object mProcessLock = new Object();
    private Thread mProcessThread = null;
    private VpnProfile mProfile;
    private String mDomain = null;
    private CIDRIP mLocalIP = null;
    private int mMtu;
    private String mLocalIPv6 = null;
    private DeviceStateReceiver mDeviceStateReceiver;
    private boolean mDisplayBytecount = false;
    private boolean mStarting = false;
    private long mConnecttime;
    private boolean mOvpn3 = false;
    private OpenVPNManagement mManagement;
    private String mLastTunCfg;
    private String mRemoteGW;
    private Handler guiHandler;
    private Toast mlastToast;
    private Runnable mOpenVPNThread;
    ConnectionStateMonitor connectionStateMonitor;
    Intent intent;
    int startId;
    int flags;
    public static final String ACTION_NETWORK_AVAILABLE = "com.vpn.fastestvpnservice.ACTION_NETWORK_AVAILABLE";
    public static final String ACTION_NETWORK_LOST = "com.vpn.fastestvpnservice.LOST";

    public static String humanReadableByteCount(long bytes, boolean mbit) {
        int unit;
        if (mbit) {
            bytes *= 8L;
        }
        int n = unit = mbit ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + (mbit ? " bit" : " B");
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (mbit ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (mbit ? "" : "");
        if (mbit) {
            return String.format(Locale.getDefault(), "%.1f %sbit", (double)bytes / Math.pow(unit, exp), pre);
        }
        return String.format(Locale.getDefault(), "%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static void setNotificationActivityClass(Class<? extends Activity> activityClass) {
        mNotificationActivityClass = activityClass;
    }

    public IBinder onBind(Intent intent) {
        String action = intent.getAction();
        if (action != null && action.equals(START_SERVICE)) {
            return this.mBinder;
        }
        return super.onBind(intent);
    }

    public void onRevoke() {
        VpnStatus.logError(R.string.permission_revoked);
        this.mManagement.stopVPN(false);
        this.endVpnService();
    }

    public void processDied() {
        this.endVpnService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endVpnService() {
        Object object = this.mProcessLock;
        synchronized (object) {
            this.mProcessThread = null;
        }
        VpnStatus.removeByteCountListener(this);
        this.unregisterDeviceStateReceiver();
        this.mOpenVPNThread = null;
        if (!this.mStarting) {
            this.stopForeground(!mNotificationAlwaysVisible);
            if (!mNotificationAlwaysVisible) {
                this.stopSelf();
                VpnStatus.removeStateListener(this);
            }
        }
    }

    private void showNotification(final String msg, String tickerText, boolean lowpriority, long when, VpnStatus.ConnectionStatus status) {
        String ns = "notification";
        NotificationManager mNotificationManager = (NotificationManager)this.getSystemService(ns);
        String CHANNEL_ID = "10001";
        if (Build.VERSION.SDK_INT >= 26) {
            String name = "FastestVPN";
            int importance = 4;
            NotificationChannel mChannel = new NotificationChannel(CHANNEL_ID, (CharSequence)name, importance);
            mChannel.setDescription(msg);
            mChannel.enableLights(true);
            mChannel.setLightColor(-65536);
            mChannel.enableVibration(true);
            mChannel.setVibrationPattern(new long[]{100L, 200L, 300L, 400L, 500L, 400L, 300L, 200L, 400L});
            mChannel.setShowBadge(false);
            if (mNotificationManager != null) {
                mNotificationManager.createNotificationChannel(mChannel);
            }
        }
        int icon = this.getIconByConnectionStatus(status);
        Notification.Builder nbuilder = new Notification.Builder((Context)this);
        if (this.mProfile != null) {
            nbuilder.setContentTitle((CharSequence)this.getString(R.string.notifcation_title, new Object[]{this.mProfile.mName}));
        } else {
            nbuilder.setContentTitle((CharSequence)this.getString(R.string.notifcation_title_notconnect));
        }
        nbuilder.setContentText((CharSequence)msg);
        nbuilder.setOnlyAlertOnce(true);
        nbuilder.setOngoing(true);
        if (Build.VERSION.SDK_INT >= 26) {
            nbuilder.setChannelId(CHANNEL_ID);
        }
        nbuilder.setSmallIcon(icon).setLargeIcon(BitmapFactory.decodeResource((Resources)this.getResources(), (int)icon));
        nbuilder.setAutoCancel(true);
        if (when != 0L) {
            nbuilder.setWhen(when);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            this.jbNotificationExtras(lowpriority, nbuilder);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.lpNotificationExtras(nbuilder);
        }
        if (tickerText != null && !tickerText.equals("")) {
            nbuilder.setTicker((CharSequence)tickerText);
        }
        Notification notification = nbuilder.getNotification();
        if (mNotificationManager != null) {
            mNotificationManager.notify(1, notification);
        }
        this.startForeground(1, notification);
        if (this.runningOnAndroidTV() && !lowpriority) {
            this.guiHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (OpenVPNService.this.mlastToast != null) {
                        OpenVPNService.this.mlastToast.cancel();
                    }
                    String toastText = String.format(Locale.getDefault(), "%s - %s", ((OpenVPNService)OpenVPNService.this).mProfile.mName, msg);
                    OpenVPNService.this.mlastToast = Toast.makeText((Context)OpenVPNService.this.getBaseContext(), (CharSequence)toastText, (int)0);
                    OpenVPNService.this.mlastToast.show();
                }
            });
        }
    }

    @TargetApi(value=21)
    private void lpNotificationExtras(Notification.Builder builder) {
        builder.setCategory("service");
        builder.setLocalOnly(true);
    }

    private boolean runningOnAndroidTV() {
        UiModeManager uiModeManager = (UiModeManager)this.getSystemService("uimode");
        if (uiModeManager != null) {
            return uiModeManager.getCurrentModeType() == 4;
        }
        return false;
    }

    private int getIconByConnectionStatus(VpnStatus.ConnectionStatus level) {
        switch (level) {
            case LEVEL_CONNECTED: {
                return R.drawable.ic_stat_vpn_outline;
            }
            case LEVEL_AUTH_FAILED: 
            case LEVEL_NONETWORK: 
            case LEVEL_NOTCONNECTED: {
                return R.drawable.ic_stat_vpn_outline;
            }
            case LEVEL_CONNECTING_NO_SERVER_REPLY_YET: 
            case LEVEL_WAITING_FOR_USER_INPUT: {
                return R.drawable.ic_stat_vpn_outline;
            }
            case LEVEL_CONNECTING_SERVER_REPLIED: {
                return R.drawable.ic_stat_vpn_outline;
            }
            case LEVEL_VPNPAUSED: {
                return 17301539;
            }
        }
        return R.drawable.ic_stat_vpn_outline;
    }

    @TargetApi(value=16)
    private void jbNotificationExtras(boolean lowpriority, Notification.Builder builder) {
        try {
            PendingIntent pendingIntent;
            if (lowpriority) {
                Method setpriority = builder.getClass().getMethod("setPriority", Integer.TYPE);
                setpriority.invoke((Object)builder, -2);
                Method setUsesChronometer = builder.getClass().getMethod("setUsesChronometer", Boolean.TYPE);
                setUsesChronometer.invoke((Object)builder, true);
            }
            Intent pauseVPN = new Intent((Context)this, OpenVPNService.class);
            if (this.mDeviceStateReceiver == null || !this.mDeviceStateReceiver.isUserPaused()) {
                pauseVPN.setAction(PAUSE_VPN);
                pendingIntent = PendingIntent.getService((Context)this, (int)0, (Intent)pauseVPN, (int)0);
            } else {
                pauseVPN.setAction(RESUME_VPN);
                pendingIntent = PendingIntent.getService((Context)this, (int)0, (Intent)pauseVPN, (int)0);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException e) {
            VpnStatus.logException(e);
        }
    }

    PendingIntent getLogPendingIntent() {
        Intent disconnectVPN = new Intent((Context)this, DisconnectVPNActivity.class);
        disconnectVPN.setAction(DISCONNECT_VPN);
        return PendingIntent.getActivity((Context)this, (int)0, (Intent)disconnectVPN, (int)0);
    }

    synchronized void registerDeviceStateReceiver(OpenVPNManagement magnagement) {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.SCREEN_ON");
        this.mDeviceStateReceiver = new DeviceStateReceiver(magnagement);
        this.registerReceiver(this.mDeviceStateReceiver, filter);
        VpnStatus.addByteCountListener(this.mDeviceStateReceiver);
        this.connectionStateMonitor = new ConnectionStateMonitor();
        this.connectionStateMonitor.enable();
        Log.d((String)TAG, (String)"registered");
    }

    synchronized void unregisterDeviceStateReceiver() {
        if (this.mDeviceStateReceiver != null) {
            try {
                VpnStatus.removeByteCountListener(this.mDeviceStateReceiver);
                this.unregisterReceiver(this.mDeviceStateReceiver);
            }
            catch (IllegalArgumentException iae) {
                iae.printStackTrace();
            }
        }
        this.mDeviceStateReceiver = null;
        if (this.connectionStateMonitor != null) {
            Log.d((String)TAG, (String)"unregistered");
            this.connectionStateMonitor.disable();
        }
    }

    public void userPause(boolean shouldBePaused) {
        if (this.mDeviceStateReceiver != null) {
            this.mDeviceStateReceiver.userPause(shouldBePaused);
        }
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.intent = intent;
        this.flags = flags;
        this.startId = startId;
        if (intent != null && intent.getBooleanExtra(ALWAYS_SHOW_NOTIFICATION, false)) {
            mNotificationAlwaysVisible = true;
        }
        VpnStatus.addStateListener(this);
        VpnStatus.addByteCountListener(this);
        this.guiHandler = new Handler(this.getMainLooper());
        if (intent != null && PAUSE_VPN.equals(intent.getAction())) {
            if (this.mDeviceStateReceiver != null) {
                this.mDeviceStateReceiver.userPause(true);
            }
            return 2;
        }
        if (intent != null && RESUME_VPN.equals(intent.getAction())) {
            if (this.mDeviceStateReceiver != null) {
                this.mDeviceStateReceiver.userPause(false);
            }
            return 2;
        }
        if (intent != null && START_SERVICE.equals(intent.getAction())) {
            return 2;
        }
        if (intent != null && START_SERVICE_STICKY.equals(intent.getAction())) {
            return 3;
        }
        if (intent != null && intent.hasExtra(this.getPackageName() + ".profileUUID")) {
            String profileUUID = intent.getStringExtra(this.getPackageName() + ".profileUUID");
            this.mProfile = ProfileManager.get((Context)this, profileUUID);
            Log.d((String)TAG, (String)("onStartCommand: " + this.mProfile));
        } else {
            this.mProfile = ProfileManager.getLastConnectedProfile((Context)this);
            VpnStatus.logInfo(R.string.service_restarted, new Object[0]);
            if (this.mProfile == null) {
                Log.d((String)"OpenVPN", (String)"Got no last connected profile on null intent. Assuming always on.");
                this.mProfile = ProfileManager.getAlwaysOnVPN((Context)this);
                if (this.mProfile == null) {
                    this.stopSelf(startId);
                    return 2;
                }
            }
            this.mProfile.checkForRestart((Context)this);
            intent = this.mProfile.getStartServiceIntent((Context)this);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                OpenVPNService.this.startOpenVPN();
            }
        }).start();
        ProfileManager.setConnectedVpnProfile((Context)this, this.mProfile);
        if (this.mProfile.needUserPWInput(true) != 0) {
            return 2;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startOpenVPN() {
        Runnable processThread;
        VpnStatus.logInfo(R.string.building_configration, new Object[0]);
        VpnStatus.updateStateString("VPN_GENERATE_CONFIG", "", R.string.building_configration, VpnStatus.ConnectionStatus.LEVEL_START);
        try {
            this.mProfile.writeConfigFile((Context)this);
        }
        catch (IOException e) {
            VpnStatus.logException("Error writing config file", e);
            this.endVpnService();
            return;
        }
        String prefix = this.getPackageName();
        String nativeLibraryDirectory = this.getApplicationInfo().nativeLibraryDir;
        String[] argv = VPNLaunchHelper.buildOpenvpnArgv((Context)this);
        Log.d((String)TAG, (String)("startOpenVPN: argv:" + (argv == null ? "null" : Integer.valueOf(argv.length))));
        this.mStarting = true;
        this.stopOldOpenVPNProcess();
        this.mStarting = false;
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
        this.mOvpn3 = prefs.getBoolean("ovpn3", false);
        if (!"ovpn3".equals("")) {
            this.mOvpn3 = false;
        }
        if (!this.mOvpn3) {
            OpenVpnManagementThread ovpnManagementThread = new OpenVpnManagementThread(this.mProfile, this);
            if (ovpnManagementThread.openManagementInterface((Context)this)) {
                Thread mSocketManagerThread = new Thread((Runnable)ovpnManagementThread, "OpenVPNManagementThread");
                mSocketManagerThread.start();
                this.mManagement = ovpnManagementThread;
                VpnStatus.logInfo("started Socket Thread");
            } else {
                this.endVpnService();
                return;
            }
        }
        if (this.mOvpn3) {
            Log.v((String)"ttt openvpnservice", (String)"ovp3");
            OpenVPNManagement mOpenVPN3 = this.instantiateOpenVPN3Core();
            processThread = (Runnable)((Object)mOpenVPN3);
            this.mManagement = mOpenVPN3;
        } else {
            Log.v((String)"ttt openvpnservice", (String)"not ovp3");
            this.mOpenVPNThread = processThread = new OpenVPNThread(this, argv, nativeLibraryDirectory);
        }
        Object object = this.mProcessLock;
        synchronized (object) {
            this.mProcessThread = new Thread(processThread, "OpenVPNProcessThread");
            this.mProcessThread.start();
        }
        new Handler(this.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (OpenVPNService.this.mDeviceStateReceiver != null) {
                    OpenVPNService.this.unregisterDeviceStateReceiver();
                }
                OpenVPNService.this.registerDeviceStateReceiver(OpenVPNService.this.mManagement);
            }
        });
    }

    private void stopOldOpenVPNProcess() {
        if (this.mManagement != null) {
            if (this.mOpenVPNThread != null) {
                ((OpenVPNThread)this.mOpenVPNThread).setReplaceConnection();
            }
            if (this.mManagement.stopVPN(true)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.forceStopOpenVpnProcess();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceStopOpenVpnProcess() {
        Object object = this.mProcessLock;
        synchronized (object) {
            if (this.mProcessThread != null) {
                this.mProcessThread.interrupt();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private OpenVPNManagement instantiateOpenVPN3Core() {
        try {
            Class<?> cl = Class.forName("de.blinkt.openvpn.core.OpenVPNThreadv3");
            return (OpenVPNManagement)cl.getConstructor(OpenVPNService.class, VpnProfile.class).newInstance(this, this.mProfile);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Object object = this.mProcessLock;
        synchronized (object) {
            if (this.mProcessThread != null) {
                this.mManagement.stopVPN(true);
            }
        }
        if (this.mDeviceStateReceiver != null) {
            this.unregisterReceiver(this.mDeviceStateReceiver);
        }
        VpnStatus.removeStateListener(this);
        VpnStatus.flushLog();
    }

    private String getTunConfigString() {
        String cfg = "TUNCFG UNQIUE STRING ips:";
        if (this.mLocalIP != null) {
            cfg = cfg + this.mLocalIP.toString();
        }
        cfg = cfg + "routes: " + TextUtils.join((CharSequence)"|", this.mRoutes.getNetworks(true)) + TextUtils.join((CharSequence)"|", this.mRoutesv6.getNetworks(false));
        cfg = cfg + "excl. routes:" + TextUtils.join((CharSequence)"|", this.mRoutes.getNetworks(false)) + TextUtils.join((CharSequence)"|", this.mRoutesv6.getNetworks(false));
        cfg = cfg + "dns: " + TextUtils.join((CharSequence)"|", this.mDnslist);
        cfg = cfg + "domain: " + this.mDomain;
        cfg = cfg + "mtu: " + this.mMtu;
        Log.i((String)"turConfig", (String)cfg);
        return cfg;
    }

    public ParcelFileDescriptor openTun() {
        VpnService.Builder builder = new VpnService.Builder((VpnService)this);
        builder.setBlocking(false);
        VpnStatus.logInfo(R.string.last_openvpn_tun_config, new Object[0]);
        if (Build.VERSION.SDK_INT >= 21 && this.mProfile.mAllowLocalLAN) {
            this.allowAllAFFamilies(builder);
        }
        if (this.mLocalIP == null && this.mLocalIPv6 == null) {
            VpnStatus.logError(this.getString(R.string.opentun_no_ipaddr));
            return null;
        }
        if (this.mLocalIP != null) {
            this.addLocalNetworksToRoutes();
            try {
                builder.addAddress(this.mLocalIP.mIp, this.mLocalIP.len);
            }
            catch (IllegalArgumentException iae) {
                VpnStatus.logError(R.string.dns_add_error, this.mLocalIP, iae.getLocalizedMessage());
                return null;
            }
        }
        for (String dns : this.mDnslist) {
            try {
                builder.addDnsServer(dns);
            }
            catch (IllegalArgumentException iae) {
                VpnStatus.logError(R.string.dns_add_error, dns, iae.getLocalizedMessage());
            }
        }
        String release = Build.VERSION.RELEASE;
        if (!(Build.VERSION.SDK_INT != 19 || release.startsWith("4.4.3") || release.startsWith("4.4.4") || release.startsWith("4.4.5") || release.startsWith("4.4.6") || this.mMtu >= 1280)) {
            VpnStatus.logInfo(String.format(Locale.US, "Forcing MTU to 1280 instead of %d to workaround Android Bug #70916", this.mMtu));
            builder.setMtu(1280);
        } else {
            builder.setMtu(this.mMtu);
        }
        Collection<NetworkSpace.ipAddress> positiveIPv4Routes = this.mRoutes.getPositiveIPList();
        if ("samsung".equals(Build.BRAND) && Build.VERSION.SDK_INT >= 21 && this.mDnslist.size() >= 1) {
            try {
                NetworkSpace.ipAddress dnsServer = new NetworkSpace.ipAddress(new CIDRIP(this.mDnslist.get(0), 32), true);
                boolean dnsIncluded = false;
                for (NetworkSpace.ipAddress net : positiveIPv4Routes) {
                    if (!net.containsNet(dnsServer)) continue;
                    dnsIncluded = true;
                }
                if (!dnsIncluded) {
                    String samsungwarning = String.format("Warning Samsung Android 5.0+ devices ignore DNS servers outside the VPN range. To enable DNS resolution a route to your DNS Server (%s) has been added.", this.mDnslist.get(0));
                    VpnStatus.logWarning(samsungwarning);
                    positiveIPv4Routes.add(dnsServer);
                }
            }
            catch (Exception e) {
                VpnStatus.logError("Error parsing DNS Server IP: " + this.mDnslist.get(0));
            }
        }
        NetworkSpace.ipAddress multicastRange = new NetworkSpace.ipAddress(new CIDRIP("224.0.0.0", 3), true);
        for (NetworkSpace.ipAddress route : positiveIPv4Routes) {
            try {
                if (multicastRange.containsNet(route)) {
                    VpnStatus.logDebug(R.string.ignore_multicast_route, route.toString());
                    continue;
                }
                builder.addRoute(route.getIPv4Address(), route.networkMask);
            }
            catch (IllegalArgumentException ia) {
                VpnStatus.logError(this.getString(R.string.route_rejected) + route + " " + ia.getLocalizedMessage());
            }
        }
        if (this.mDomain != null) {
            builder.addSearchDomain(this.mDomain);
        }
        VpnStatus.logInfo(R.string.local_ip_info, this.mLocalIP.mIp, this.mLocalIP.len, this.mLocalIPv6, this.mMtu);
        VpnStatus.logInfo(R.string.dns_server_info, TextUtils.join((CharSequence)", ", this.mDnslist), this.mDomain);
        VpnStatus.logInfo(R.string.routes_info_incl, TextUtils.join((CharSequence)", ", this.mRoutes.getNetworks(true)), TextUtils.join((CharSequence)", ", this.mRoutesv6.getNetworks(true)));
        VpnStatus.logInfo(R.string.routes_info_excl, TextUtils.join((CharSequence)", ", this.mRoutes.getNetworks(false)), TextUtils.join((CharSequence)", ", this.mRoutesv6.getNetworks(false)));
        if (Build.VERSION.SDK_INT >= 21) {
            this.setAllowedVpnPackages(builder);
        }
        String session = this.mProfile.mName;
        if (this.mLocalIP != null && this.mLocalIPv6 != null) {
            session = this.getString(R.string.session_ipv6string, new Object[]{session, this.mLocalIP, this.mLocalIPv6});
        } else if (this.mLocalIP != null) {
            session = this.getString(R.string.session_ipv4string, new Object[]{session, this.mLocalIP});
        }
        builder.setSession(session);
        if (this.mDnslist.size() == 0) {
            VpnStatus.logInfo(R.string.warn_no_dns, new Object[0]);
        }
        this.mLastTunCfg = this.getTunConfigString();
        this.mDnslist.clear();
        this.mRoutes.clear();
        this.mRoutesv6.clear();
        this.mLocalIP = null;
        this.mLocalIPv6 = null;
        this.mDomain = null;
        try {
            ParcelFileDescriptor tun = builder.establish();
            if (tun == null) {
                throw new NullPointerException("Android establish() method returned null (Really broken network configuration?)");
            }
            return tun;
        }
        catch (Exception e) {
            VpnStatus.logError(R.string.tun_open_error);
            VpnStatus.logError(this.getString(R.string.error) + e.getLocalizedMessage());
            if (Build.VERSION.SDK_INT <= 17) {
                VpnStatus.logError(R.string.tun_error_helpful);
            }
            return null;
        }
    }

    @TargetApi(value=21)
    private void allowAllAFFamilies(VpnService.Builder builder) {
        builder.allowFamily(OsConstants.AF_INET);
        builder.allowFamily(OsConstants.AF_INET6);
    }

    private void addLocalNetworksToRoutes() {
        Object[] localRoutes = NativeUtils.getIfconfig();
        for (int i = 0; i < localRoutes.length; i += 3) {
            String intf = localRoutes[i];
            String ipAddr = localRoutes[i + 1];
            String netMask = localRoutes[i + 2];
            if (intf == null || intf.equals("lo") || intf.startsWith("tun") || intf.startsWith("rmnet")) continue;
            if (ipAddr == null || netMask == null) {
                VpnStatus.logError("Local routes are broken?! (Report to author) " + TextUtils.join((CharSequence)"|", (Object[])localRoutes));
                continue;
            }
            if (ipAddr.equals(this.mLocalIP.mIp)) continue;
            if (Build.VERSION.SDK_INT < 19 && !this.mProfile.mAllowLocalLAN) {
                this.mRoutes.addIPSplit(new CIDRIP(ipAddr, netMask), true);
                continue;
            }
            if (Build.VERSION.SDK_INT < 19 || !this.mProfile.mAllowLocalLAN) continue;
            this.mRoutes.addIP(new CIDRIP(ipAddr, netMask), false);
        }
    }

    @TargetApi(value=21)
    private void setAllowedVpnPackages(VpnService.Builder builder) {
        boolean atLeastOneAllowedApp = false;
        for (String pkg : this.mProfile.mAllowedAppsVpn) {
            try {
                if (this.mProfile.mAllowedAppsVpnAreDisallowed) {
                    builder.addDisallowedApplication(pkg);
                    continue;
                }
                builder.addAllowedApplication(pkg);
                atLeastOneAllowedApp = true;
            }
            catch (PackageManager.NameNotFoundException e) {
                this.mProfile.mAllowedAppsVpn.remove(pkg);
                VpnStatus.logInfo(R.string.app_no_longer_exists, pkg);
            }
        }
        if (!this.mProfile.mAllowedAppsVpnAreDisallowed && !atLeastOneAllowedApp) {
            VpnStatus.logDebug(R.string.no_allowed_app, this.getPackageName());
            try {
                builder.addAllowedApplication(this.getPackageName());
            }
            catch (PackageManager.NameNotFoundException e) {
                VpnStatus.logError("This should not happen: " + e.getLocalizedMessage());
            }
        }
        if (this.mProfile.mAllowedAppsVpnAreDisallowed) {
            VpnStatus.logDebug(R.string.disallowed_vpn_apps_info, TextUtils.join((CharSequence)", ", this.mProfile.mAllowedAppsVpn));
        } else {
            VpnStatus.logDebug(R.string.allowed_vpn_apps_info, TextUtils.join((CharSequence)", ", this.mProfile.mAllowedAppsVpn));
        }
    }

    public void addDNS(String dns) {
        this.mDnslist.add(dns);
    }

    public void setDomain(String domain) {
        if (this.mDomain == null) {
            this.mDomain = domain;
        }
    }

    public void addRoute(CIDRIP route) {
        this.mRoutes.addIP(route, true);
    }

    public void addRoute(String dest, String mask, String gateway, String device) {
        CIDRIP route = new CIDRIP(dest, mask);
        boolean include = this.isAndroidTunDevice(device);
        NetworkSpace.ipAddress gatewayIP = new NetworkSpace.ipAddress(new CIDRIP(gateway, 32), false);
        if (this.mLocalIP == null) {
            VpnStatus.logError("Local IP address unset and received. Neither pushed server config nor local config specifies an IP addresses. Opening tun device is most likely going to fail.");
            return;
        }
        NetworkSpace.ipAddress localNet = new NetworkSpace.ipAddress(this.mLocalIP, true);
        if (localNet.containsNet(gatewayIP)) {
            include = true;
        }
        if (gateway != null && (gateway.equals("255.255.255.255") || gateway.equals(this.mRemoteGW))) {
            include = true;
        }
        if (route.len == 32 && !mask.equals("255.255.255.255")) {
            VpnStatus.logWarning(R.string.route_not_cidr, dest, mask);
        }
        if (route.normalise()) {
            VpnStatus.logWarning(R.string.route_not_netip, dest, route.len, route.mIp);
        }
        this.mRoutes.addIP(route, include);
    }

    public void addRoutev6(String network, String device) {
        String[] v6parts = network.split("/");
        boolean included = this.isAndroidTunDevice(device);
        try {
            Inet6Address ip = (Inet6Address)InetAddress.getAllByName(v6parts[0])[0];
            int mask = Integer.parseInt(v6parts[1]);
            this.mRoutesv6.addIPv6(ip, mask, included);
        }
        catch (UnknownHostException e) {
            VpnStatus.logException(e);
        }
    }

    private boolean isAndroidTunDevice(String device) {
        return device != null && (device.startsWith("tun") || "(null)".equals(device) || "vpnservice-tun".equals(device));
    }

    public void setMtu(int mtu) {
        this.mMtu = mtu;
    }

    public void setLocalIP(CIDRIP cdrip) {
        this.mLocalIP = cdrip;
    }

    public void setLocalIP(String local, String netmask, int mtu, String mode) {
        this.mLocalIP = new CIDRIP(local, netmask);
        this.mMtu = mtu;
        this.mRemoteGW = null;
        long netMaskAsInt = CIDRIP.getInt(netmask);
        if (this.mLocalIP.len == 32 && !netmask.equals("255.255.255.255")) {
            long mask;
            int masklen;
            if ("net30".equals(mode)) {
                masklen = 30;
                mask = -4L;
            } else {
                masklen = 31;
                mask = -2L;
            }
            if ((netMaskAsInt & mask) == (this.mLocalIP.getInt() & mask)) {
                this.mLocalIP.len = masklen;
            } else {
                this.mLocalIP.len = 32;
                if (!"p2p".equals(mode)) {
                    VpnStatus.logWarning(R.string.ip_not_cidr, local, netmask, mode);
                }
            }
        }
        if ("p2p".equals(mode) && this.mLocalIP.len < 32 || "net30".equals(mode) && this.mLocalIP.len < 30) {
            VpnStatus.logWarning(R.string.ip_looks_like_subnet, local, netmask, mode);
        }
        if (this.mLocalIP.len <= 31 && Build.VERSION.SDK_INT >= 21) {
            CIDRIP interfaceRoute = new CIDRIP(this.mLocalIP.mIp, this.mLocalIP.len);
            interfaceRoute.normalise();
            this.addRoute(interfaceRoute);
        }
        this.mRemoteGW = netmask;
    }

    public void setLocalIPv6(String ipv6addr) {
        this.mLocalIPv6 = ipv6addr;
    }

    @Override
    public void updateState(String state, String logmessage, int resid, VpnStatus.ConnectionStatus level) {
        this.doSendBroadcast(state, level);
        if (this.mProcessThread == null && !mNotificationAlwaysVisible) {
            return;
        }
        boolean lowpriority = false;
        if (level == VpnStatus.ConnectionStatus.LEVEL_WAITING_FOR_USER_INPUT) {
            return;
        }
        if (level == VpnStatus.ConnectionStatus.LEVEL_CONNECTED) {
            this.mDisplayBytecount = true;
            this.mConnecttime = System.currentTimeMillis();
            if (!this.runningOnAndroidTV()) {
                lowpriority = true;
            }
        } else if (level == VpnStatus.ConnectionStatus.LEVEL_NONETWORK && state.equals("NONETWORK")) {
            this.endVpnService();
        } else {
            this.mDisplayBytecount = false;
        }
        String msg = this.getString(resid);
        this.showNotification(VpnStatus.getLastCleanLogMessage((Context)this), msg, lowpriority, 0L, level);
    }

    private void doSendBroadcast(String state, VpnStatus.ConnectionStatus level) {
        Intent vpnstatus = new Intent();
        vpnstatus.setAction("de.blinkt.openvpn.VPN_STATUS");
        vpnstatus.putExtra("status", level.toString());
        vpnstatus.putExtra("detailstatus", state);
        this.sendBroadcast(vpnstatus, "android.permission.ACCESS_NETWORK_STATE");
    }

    @Override
    public void updateByteCount(long in, long out, long diffIn, long diffOut) {
        if (this.mDisplayBytecount) {
            String netstat = String.format(this.getString(R.string.statusline_bytecount), OpenVPNService.humanReadableByteCount(in, false), OpenVPNService.humanReadableByteCount(diffIn / 2L, false), OpenVPNService.humanReadableByteCount(out, false), OpenVPNService.humanReadableByteCount(diffOut / 2L, false));
            boolean lowpriority = !mNotificationAlwaysVisible;
            this.showNotification(netstat, null, lowpriority, this.mConnecttime, VpnStatus.ConnectionStatus.LEVEL_CONNECTED);
        }
    }

    public boolean handleMessage(Message msg) {
        Runnable r = msg.getCallback();
        if (r != null) {
            r.run();
            return true;
        }
        return false;
    }

    public OpenVPNManagement getManagement() {
        return this.mManagement;
    }

    public String getTunReopenStatus() {
        String currentConfiguration = this.getTunConfigString();
        if (currentConfiguration.equals(this.mLastTunCfg)) {
            return "NOACTION";
        }
        String release = Build.VERSION.RELEASE;
        if (!(Build.VERSION.SDK_INT != 19 || release.startsWith("4.4.3") || release.startsWith("4.4.4") || release.startsWith("4.4.5") || release.startsWith("4.4.6"))) {
            return "OPEN_AFTER_CLOSE";
        }
        return "OPEN_BEFORE_CLOSE";
    }

    public class ConnectionStateMonitor
    extends ConnectivityManager.NetworkCallback {
        final NetworkRequest networkRequest = new NetworkRequest.Builder().addTransportType(0).addTransportType(1).build();

        void enable() {
            ConnectivityManager connectivityManager = (ConnectivityManager)OpenVPNService.this.getSystemService("connectivity");
            connectivityManager.registerNetworkCallback(this.networkRequest, (ConnectivityManager.NetworkCallback)this);
        }

        void disable() {
            ConnectivityManager connectivityManager = (ConnectivityManager)OpenVPNService.this.getSystemService("connectivity");
            connectivityManager.unregisterNetworkCallback((ConnectivityManager.NetworkCallback)this);
        }

        public void onAvailable(Network network) {
            Log.d((String)TAG, (String)"onAvailable");
            if (OpenVPNService.this.mDeviceStateReceiver != null && OpenVPNService.this.mDeviceStateReceiver.isUserPaused() && OpenVPNService.this.intent != null) {
                OpenVPNService.this.onStartCommand(OpenVPNService.this.intent, OpenVPNService.this.flags, OpenVPNService.this.startId);
                OpenVPNService.this.mDeviceStateReceiver.userPause(false);
                LocalBroadcastManager.getInstance((Context)OpenVPNService.this.getBaseContext()).sendBroadcast(new Intent(OpenVPNService.ACTION_NETWORK_AVAILABLE));
            }
        }

        public void onLost(Network network) {
            super.onLost(network);
            Log.d((String)TAG, (String)"onLost");
            if (OpenVPNService.this.mDeviceStateReceiver != null) {
                OpenVPNService.this.mDeviceStateReceiver.userPause(true);
            }
            LocalBroadcastManager.getInstance((Context)OpenVPNService.this.getBaseContext()).sendBroadcast(new Intent(OpenVPNService.ACTION_NETWORK_LOST));
        }
    }

    public class LocalBinder
    extends Binder {
        public OpenVPNService getService() {
            return OpenVPNService.this;
        }
    }
}

