/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import de.blinkt.openvpn.VpnProfile;
import de.blinkt.openvpn.core.VpnStatus;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;

public class ProfileManager {
    private static final String PREFS_NAME = "VPNList";
    private static final String LAST_CONNECTED_PROFILE = "lastConnectedProfile";
    private static ProfileManager instance;
    private static VpnProfile mLastConnectedVpn;
    private static VpnProfile tmpprofile;
    private HashMap<String, VpnProfile> profiles = new HashMap();

    private ProfileManager() {
    }

    private static VpnProfile get(String key) {
        if (tmpprofile != null && tmpprofile.getUUIDString().equals(key)) {
            return tmpprofile;
        }
        if (instance == null) {
            return null;
        }
        return ProfileManager.instance.profiles.get(key);
    }

    private static void checkInstance(Context context) {
        if (instance == null) {
            instance = new ProfileManager();
            instance.loadVPNList(context);
        }
    }

    public static synchronized ProfileManager getInstance(Context context) {
        ProfileManager.checkInstance(context);
        return instance;
    }

    public static void setConntectedVpnProfileDisconnected(Context c) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)c);
        SharedPreferences.Editor prefsedit = prefs.edit();
        prefsedit.putString(LAST_CONNECTED_PROFILE, null);
        prefsedit.apply();
    }

    public static void setConnectedVpnProfile(Context c, VpnProfile connectedProfile) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)c);
        SharedPreferences.Editor prefsedit = prefs.edit();
        prefsedit.putString(LAST_CONNECTED_PROFILE, connectedProfile.getUUIDString());
        prefsedit.apply();
        mLastConnectedVpn = connectedProfile;
    }

    public static VpnProfile getLastConnectedProfile(Context c) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)c);
        String lastConnectedProfile = prefs.getString(LAST_CONNECTED_PROFILE, null);
        if (lastConnectedProfile != null) {
            return ProfileManager.get(c, lastConnectedProfile);
        }
        return null;
    }

    public static void setTemporaryProfile(VpnProfile tmp) {
        tmpprofile = tmp;
    }

    public static boolean isTempProfile() {
        return mLastConnectedVpn == tmpprofile;
    }

    public static VpnProfile get(Context context, String profileUUID) {
        ProfileManager.checkInstance(context);
        return ProfileManager.get(profileUUID);
    }

    public static VpnProfile getLastConnectedVpn() {
        return mLastConnectedVpn;
    }

    public static VpnProfile getAlwaysOnVPN(Context context) {
        ProfileManager.checkInstance(context);
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        String uuid = prefs.getString("alwaysOnVpn", null);
        return ProfileManager.get(uuid);
    }

    public Collection<VpnProfile> getProfiles() {
        return this.profiles.values();
    }

    public VpnProfile getProfileByName(String name) {
        for (VpnProfile vpnp : this.profiles.values()) {
            if (!vpnp.getName().equals(name)) continue;
            return vpnp;
        }
        return null;
    }

    public void saveProfileList(Context context) {
        SharedPreferences sharedprefs = context.getSharedPreferences(PREFS_NAME, 0);
        SharedPreferences.Editor editor = sharedprefs.edit();
        editor.putStringSet("vpnlist", this.profiles.keySet());
        int counter = sharedprefs.getInt("counter", 0);
        editor.putInt("counter", counter + 1);
        editor.apply();
    }

    public void addProfile(VpnProfile profile) {
        this.profiles.put(profile.getUUID().toString(), profile);
    }

    public void saveProfile(Context context, VpnProfile profile) {
        try {
            ObjectOutputStream vpnfile = new ObjectOutputStream(context.openFileOutput(profile.getUUID().toString() + ".vp", 0));
            vpnfile.writeObject(profile);
            vpnfile.flush();
            vpnfile.close();
        }
        catch (IOException e) {
            VpnStatus.logException("saving VPN profile", e);
            throw new RuntimeException(e);
        }
    }

    private void loadVPNList(Context context) {
        this.profiles = new HashMap();
        SharedPreferences listpref = context.getSharedPreferences(PREFS_NAME, 0);
        HashSet vlist = listpref.getStringSet("vpnlist", null);
        if (vlist == null) {
            vlist = new HashSet();
        }
        for (String vpnentry : vlist) {
            try {
                ObjectInputStream vpnfile = new ObjectInputStream(context.openFileInput(vpnentry + ".vp"));
                VpnProfile vp = (VpnProfile)vpnfile.readObject();
                if (vp == null || vp.mName == null || vp.getUUID() == null) continue;
                vp.upgradeProfile();
                this.profiles.put(vp.getUUID().toString(), vp);
            }
            catch (IOException | ClassNotFoundException e) {
                VpnStatus.logException("Loading VPN List", e);
            }
        }
    }

    public void removeProfile(Context context, VpnProfile profile) {
        String vpnentry = profile.getUUID().toString();
        this.profiles.remove(vpnentry);
        this.saveProfileList(context);
        context.deleteFile(vpnentry + ".vp");
        if (mLastConnectedVpn == profile) {
            mLastConnectedVpn = null;
        }
    }

    static {
        mLastConnectedVpn = null;
        tmpprofile = null;
    }
}

