/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn.core;

import android.annotation.TargetApi;
import android.net.ConnectivityManager;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import de.blinkt.openvpn.core.VpnStatus;

@TargetApi(value=21)
public class LollipopDeviceStateListener
extends ConnectivityManager.NetworkCallback {
    private String mLastConnectedStatus;
    private String mLastLinkProperties;
    private String mLastNetworkCapabilities;

    public void onAvailable(Network network) {
        super.onAvailable(network);
        if (!network.toString().equals(this.mLastConnectedStatus)) {
            this.mLastConnectedStatus = network.toString();
            VpnStatus.logDebug("Connected to " + this.mLastConnectedStatus);
        }
    }

    public void onLinkPropertiesChanged(Network network, LinkProperties linkProperties) {
        super.onLinkPropertiesChanged(network, linkProperties);
        if (!linkProperties.toString().equals(this.mLastLinkProperties)) {
            this.mLastLinkProperties = linkProperties.toString();
            VpnStatus.logDebug(String.format("Linkproperties of %s: %s", network, linkProperties));
        }
    }

    public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
        super.onCapabilitiesChanged(network, networkCapabilities);
        if (!networkCapabilities.toString().equals(this.mLastNetworkCapabilities)) {
            this.mLastNetworkCapabilities = networkCapabilities.toString();
            VpnStatus.logDebug(String.format("Network capabilities of %s: %s", network, networkCapabilities));
        }
    }
}

