/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn.core;

import android.support.v4.util.Pair;
import android.text.TextUtils;
import de.blinkt.openvpn.VpnProfile;
import de.blinkt.openvpn.core.CIDRIP;
import de.blinkt.openvpn.core.Connection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Vector;

public class ConfigParser {
    private static final String CONVERTED_PROFILE = "converted Profile";
    private final String[] unsupportedOptions = new String[]{"config", "tls-server"};
    private final String[] ignoreOptions = new String[]{"tls-client", "askpass", "auth-nocache", "up", "down", "route-up", "ipchange", "route-up", "route-pre-down", "auth-user-pass-verify", "block-outside-dns", "dhcp-release", "dhcp-renew", "dh", "group", "ip-win32", "management-hold", "management", "management-client", "management-query-remote", "management-query-passwords", "management-query-proxy", "management-external-key", "management-forget-disconnect", "management-signal", "management-log-cache", "management-up-down", "management-client-user", "management-client-group", "pause-exit", "plugin", "machine-readable-output", "persist-key", "push", "register-dns", "route-delay", "route-gateway", "route-metric", "route-method", "status", "script-security", "show-net-up", "suppress-timestamps", "tmp-dir", "tun-ipv6", "topology", "user", "win-sys"};
    private final String[][] ignoreOptionsWithArg = new String[][]{{"setenv", "IV_GUI_VER"}, {"setenv", "IV_OPENVPN_GUI_VERSION"}, {"engine", "dynamic"}, {"setenv", "CLIENT_CERT"}};
    private HashMap<String, Vector<Vector<String>>> options = new HashMap();
    private HashMap<String, Vector<String>> meta = new HashMap();

    private static void useEmbbedUserAuth(VpnProfile np, String inlinedata) {
        String data = VpnProfile.getEmbeddedContent(inlinedata);
        String[] parts = data.split("\n");
        if (parts.length >= 2) {
            np.mUsername = parts[0];
            np.mPassword = parts[1];
        }
    }

    public void parseConfig(Reader reader) throws IOException, ConfigParseError {
        HashMap<String, String> optionAliases = new HashMap<String, String>();
        optionAliases.put("server-poll-timeout", "timeout-connect");
        BufferedReader br = new BufferedReader(reader);
        int lineno = 0;
        try {
            while (true) {
                String line = br.readLine();
                ++lineno;
                if (line != null) {
                    if (lineno == 1) {
                        if (line.startsWith("PK\u0003\u0004") || line.startsWith("PK\u0007\u00008")) {
                            throw new ConfigParseError("Input looks like a ZIP Archive. Import is only possible for OpenVPN config files (.ovpn/.conf)");
                        }
                        if (line.startsWith("\ufeff")) {
                            line = line.substring(1);
                        }
                    }
                    if (line.startsWith("# OVPN_ACCESS_SERVER_")) {
                        Vector<String> metaarg = this.parsemeta(line);
                        this.meta.put(metaarg.get(0), metaarg);
                        continue;
                    }
                    Vector<String> args = this.parseline(line);
                    if (args.size() == 0) continue;
                    if (args.get(0).startsWith("--")) {
                        args.set(0, args.get(0).substring(2));
                    }
                    this.checkinlinefile(args, br);
                    String optionname = args.get(0);
                    if (optionAliases.get(optionname) != null) {
                        optionname = (String)optionAliases.get(optionname);
                    }
                    if (!this.options.containsKey(optionname)) {
                        this.options.put(optionname, new Vector());
                    }
                    this.options.get(optionname).add(args);
                    continue;
                }
                break;
            }
        }
        catch (OutOfMemoryError memoryError) {
            throw new ConfigParseError("File too large to parse: " + memoryError.getLocalizedMessage());
        }
    }

    private Vector<String> parsemeta(String line) {
        String meta = line.split("#\\sOVPN_ACCESS_SERVER_", 2)[1];
        String[] parts = meta.split("=", 2);
        Vector<String> rval = new Vector<String>();
        Collections.addAll(rval, parts);
        return rval;
    }

    private void checkinlinefile(Vector<String> args, BufferedReader br) throws IOException, ConfigParseError {
        String arg0 = args.get(0).trim();
        if (arg0.startsWith("<") && arg0.endsWith(">")) {
            String argname = arg0.substring(1, arg0.length() - 1);
            String inlinefile = "[[INLINE]]";
            String endtag = String.format("</%s>", argname);
            while (true) {
                String line;
                if ((line = br.readLine()) == null) {
                    throw new ConfigParseError(String.format("No endtag </%s> for starttag <%s> found", argname, argname));
                }
                if (line.trim().equals(endtag)) break;
                inlinefile = inlinefile + line;
                inlinefile = inlinefile + "\n";
            }
            if (inlinefile.endsWith("\n")) {
                inlinefile = inlinefile.substring(0, inlinefile.length() - 1);
            }
            args.clear();
            args.add(argname);
            args.add(inlinefile);
        }
    }

    private boolean space(char c) {
        return Character.isWhitespace(c) || c == '\u0000';
    }

    private Vector<String> parseline(String line) throws ConfigParseError {
        Vector<String> parameters = new Vector<String>();
        if (line.length() == 0) {
            return parameters;
        }
        linestate state = linestate.initial;
        boolean backslash = false;
        char out = '\u0000';
        int pos = 0;
        String currentarg = "";
        do {
            char in = pos < line.length() ? line.charAt(pos) : (char)'\u0000';
            if (!backslash && in == '\\' && state != linestate.readin_single_quote) {
                backslash = true;
            } else {
                if (state == linestate.initial) {
                    if (!this.space(in)) {
                        if (in == ';' || in == '#') break;
                        if (!backslash && in == '\"') {
                            state = linestate.reading_quoted;
                        } else if (!backslash && in == '\'') {
                            state = linestate.readin_single_quote;
                        } else {
                            out = in;
                            state = linestate.reading_unquoted;
                        }
                    }
                } else if (state == linestate.reading_unquoted) {
                    if (!backslash && this.space(in)) {
                        state = linestate.done;
                    } else {
                        out = in;
                    }
                } else if (state == linestate.reading_quoted) {
                    if (!backslash && in == '\"') {
                        state = linestate.done;
                    } else {
                        out = in;
                    }
                } else if (in == '\'') {
                    state = linestate.done;
                } else {
                    out = in;
                }
                if (state == linestate.done) {
                    state = linestate.initial;
                    parameters.add(currentarg);
                    currentarg = "";
                    out = '\u0000';
                }
                if (backslash && out != '\u0000' && out != '\\' && out != '\"' && !this.space(out)) {
                    throw new ConfigParseError("Options warning: Bad backslash ('\\') usage");
                }
                backslash = false;
            }
            if (out == '\u0000') continue;
            currentarg = currentarg + out;
        } while (pos++ < line.length());
        return parameters;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public VpnProfile convertProfile() throws ConfigParseError, IOException {
        Vector<String> ocusername;
        Vector<String> friendlyname;
        Vector<String> protoforce;
        Vector<String> crlfile;
        Vector<String> authuser;
        Vector<Vector<String>> remotetls;
        Vector<String> connectretrymax;
        Vector<String> connectretry;
        Vector<String> verb;
        Vector<String> x509usernamefield;
        Vector<String> verifyx509name;
        Vector<String> cryptoapicert;
        Vector<String> pkcs12;
        Vector<String> key;
        Vector<String> cert;
        Vector<String> ca;
        Vector<String> auth;
        Vector<String> cipher;
        Vector<String> ifconfig;
        Vector<String> mode;
        Vector<Vector<String>> redirectPrivate;
        Vector<Vector<String>> defgw;
        Vector<String> direction;
        Vector<Vector<String>> tlsauthoptions;
        Vector<String> routeNoPull;
        Vector<Vector<String>> routes;
        Vector<String> secret;
        boolean noauthtypeset = true;
        VpnProfile np = new VpnProfile(CONVERTED_PROFILE);
        np.clearDefaults();
        if (this.options.containsKey("client") || this.options.containsKey("pull")) {
            np.mUsePull = true;
            this.options.remove("pull");
            this.options.remove("client");
        }
        if ((secret = this.getOption("secret", 1, 2)) != null) {
            np.mAuthenticationType = 4;
            noauthtypeset = false;
            np.mUseTLSAuth = true;
            np.mTLSAuthFilename = secret.get(1);
            if (secret.size() == 3) {
                np.mTLSAuthDirection = secret.get(2);
            }
        }
        if ((routes = this.getAllOption("route", 1, 4)) != null) {
            String routeopt = "";
            String routeExcluded = "";
            for (Vector<String> route : routes) {
                String netmask = "255.255.255.255";
                String gateway = "vpn_gateway";
                if (route.size() >= 3) {
                    netmask = route.get(2);
                }
                if (route.size() >= 4) {
                    gateway = route.get(3);
                }
                String net = route.get(1);
                try {
                    CIDRIP cidr = new CIDRIP(net, netmask);
                    if (gateway.equals("net_gateway")) {
                        routeExcluded = routeExcluded + cidr.toString() + " ";
                        continue;
                    }
                    routeopt = routeopt + cidr.toString() + " ";
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException aioob) {
                    throw new ConfigParseError("Could not parse netmask of route " + netmask);
                }
            }
            np.mCustomRoutes = routeopt;
            np.mExcludedRoutes = routeExcluded;
        }
        if ((routeNoPull = this.getOption("route-nopull", 1, 1)) != null) {
            np.mRoutenopull = true;
        }
        if ((tlsauthoptions = this.getAllOption("tls-auth", 1, 2)) != null) {
            for (Vector<String> tlsauth : tlsauthoptions) {
                if (tlsauth == null) continue;
                if (!tlsauth.get(1).equals("[inline]")) {
                    np.mTLSAuthFilename = tlsauth.get(1);
                    np.mUseTLSAuth = true;
                }
                if (tlsauth.size() != 3) continue;
                np.mTLSAuthDirection = tlsauth.get(2);
            }
        }
        if ((direction = this.getOption("key-direction", 1, 1)) != null) {
            np.mTLSAuthDirection = direction.get(1);
        }
        if ((defgw = this.getAllOption("redirect-gateway", 0, 5)) != null) {
            np.mUseDefaultRoute = true;
            this.checkRedirectParameters(np, defgw);
        }
        if ((redirectPrivate = this.getAllOption("redirect-private", 0, 5)) != null) {
            this.checkRedirectParameters(np, redirectPrivate);
        }
        Vector<String> dev = this.getOption("dev", 1, 1);
        Vector<String> devtype = this.getOption("dev-type", 1, 1);
        if (!(devtype != null && devtype.get(1).equals("tun") || dev != null && dev.get(1).startsWith("tun") || devtype == null && dev == null)) {
            throw new ConfigParseError("Sorry. Only tun mode is supported. See the FAQ for more detail");
        }
        Vector<String> mssfix = this.getOption("mssfix", 0, 1);
        if (mssfix != null) {
            if (mssfix.size() >= 2) {
                try {
                    np.mMssFix = Integer.parseInt(mssfix.get(1));
                }
                catch (NumberFormatException e) {
                    throw new ConfigParseError("Argument to --mssfix has to be an integer");
                }
            } else {
                np.mMssFix = 1450;
            }
        }
        if ((mode = this.getOption("mode", 1, 1)) != null && !mode.get(1).equals("p2p")) {
            throw new ConfigParseError("Invalid mode for --mode specified, need p2p");
        }
        Vector<Vector<String>> dhcpoptions = this.getAllOption("dhcp-option", 2, 2);
        if (dhcpoptions != null) {
            for (Vector<String> dhcpoption : dhcpoptions) {
                String type = dhcpoption.get(1);
                String arg = dhcpoption.get(2);
                if (type.equals("DOMAIN")) {
                    np.mSearchDomain = dhcpoption.get(2);
                    continue;
                }
                if (!type.equals("DNS")) continue;
                np.mOverrideDNS = true;
                if (np.mDNS1.equals(VpnProfile.DEFAULT_DNS1)) {
                    np.mDNS1 = arg;
                    continue;
                }
                np.mDNS2 = arg;
            }
        }
        if ((ifconfig = this.getOption("ifconfig", 2, 2)) != null) {
            try {
                CIDRIP cidr = new CIDRIP(ifconfig.get(1), ifconfig.get(2));
                np.mIPv4Address = cidr.toString();
            }
            catch (NumberFormatException nfe) {
                throw new ConfigParseError("Could not pase ifconfig IP address: " + nfe.getLocalizedMessage());
            }
        }
        if (this.getOption("remote-random-hostname", 0, 0) != null) {
            np.mUseRandomHostname = true;
        }
        if (this.getOption("float", 0, 0) != null) {
            np.mUseFloat = true;
        }
        if (this.getOption("comp-lzo", 0, 1) != null) {
            np.mUseLzo = true;
        }
        if ((cipher = this.getOption("cipher", 1, 1)) != null) {
            np.mCipher = cipher.get(1);
        }
        if ((auth = this.getOption("auth", 1, 1)) != null) {
            np.mAuth = auth.get(1);
        }
        if ((ca = this.getOption("ca", 1, 1)) != null) {
            np.mCaFilename = ca.get(1);
        }
        if ((cert = this.getOption("cert", 1, 1)) != null) {
            np.mClientCertFilename = cert.get(1);
            np.mAuthenticationType = 0;
            noauthtypeset = false;
        }
        if ((key = this.getOption("key", 1, 1)) != null) {
            np.mClientKeyFilename = key.get(1);
        }
        if ((pkcs12 = this.getOption("pkcs12", 1, 1)) != null) {
            np.mPKCS12Filename = pkcs12.get(1);
            np.mAuthenticationType = 2;
            noauthtypeset = false;
        }
        if ((cryptoapicert = this.getOption("cryptoapicert", 1, 1)) != null) {
            np.mAuthenticationType = 2;
            noauthtypeset = false;
        }
        Vector<String> compatnames = this.getOption("compat-names", 1, 2);
        Vector<String> nonameremapping = this.getOption("no-name-remapping", 1, 1);
        Vector<String> tlsremote = this.getOption("tls-remote", 1, 1);
        if (tlsremote != null) {
            np.mRemoteCN = tlsremote.get(1);
            np.mCheckRemoteCN = true;
            np.mX509AuthType = 0;
            if (compatnames != null && compatnames.size() > 2 || nonameremapping != null) {
                np.mX509AuthType = 1;
            }
        }
        if ((verifyx509name = this.getOption("verify-x509-name", 1, 2)) != null) {
            np.mRemoteCN = verifyx509name.get(1);
            np.mCheckRemoteCN = true;
            if (verifyx509name.size() > 2) {
                if (verifyx509name.get(2).equals("name")) {
                    np.mX509AuthType = 3;
                } else if (verifyx509name.get(2).equals("subject")) {
                    np.mX509AuthType = 2;
                } else {
                    if (!verifyx509name.get(2).equals("name-prefix")) throw new ConfigParseError("Unknown parameter to verify-x509-name: " + verifyx509name.get(2));
                    np.mX509AuthType = 4;
                }
            } else {
                np.mX509AuthType = 2;
            }
        }
        if ((x509usernamefield = this.getOption("x509-username-field", 1, 1)) != null) {
            np.mx509UsernameField = x509usernamefield.get(1);
        }
        if ((verb = this.getOption("verb", 1, 1)) != null) {
            np.mVerb = verb.get(1);
        }
        if (this.getOption("nobind", 0, 0) != null) {
            np.mNobind = true;
        }
        if (this.getOption("persist-tun", 0, 0) != null) {
            np.mPersistTun = true;
        }
        if (this.getOption("push-peer-info", 0, 0) != null) {
            np.mPushPeerInfo = true;
        }
        if ((connectretry = this.getOption("connect-retry", 1, 2)) != null) {
            np.mConnectRetry = connectretry.get(1);
            if (connectretry.size() > 2) {
                np.mConnectRetryMaxTime = connectretry.get(2);
            }
        }
        if ((connectretrymax = this.getOption("connect-retry-max", 1, 1)) != null) {
            np.mConnectRetryMax = connectretrymax.get(1);
        }
        if ((remotetls = this.getAllOption("remote-cert-tls", 1, 1)) != null) {
            if (remotetls.get(0).get(1).equals("server")) {
                np.mExpectTLSCert = true;
            } else {
                this.options.put("remotetls", remotetls);
            }
        }
        if ((authuser = this.getOption("auth-user-pass", 0, 1)) != null) {
            if (noauthtypeset) {
                np.mAuthenticationType = 3;
            } else if (np.mAuthenticationType == 0) {
                np.mAuthenticationType = 5;
            } else if (np.mAuthenticationType == 2) {
                np.mAuthenticationType = 7;
            }
            if (authuser.size() > 1) {
                np.mUsername = null;
                ConfigParser.useEmbbedUserAuth(np, authuser.get(1));
            }
        }
        if ((crlfile = this.getOption("crl-verify", 1, 2)) != null) {
            if (crlfile.size() == 3 && crlfile.get(2).equals("dir")) {
                np.mCustomConfigOptions = np.mCustomConfigOptions + TextUtils.join((CharSequence)" ", crlfile) + "\n";
            } else {
                np.mCrlFilename = crlfile.get(1);
            }
        }
        Pair<Connection, Connection[]> conns = this.parseConnectionOptions(null);
        np.mConnections = (Connection[])conns.second;
        Vector<Vector<String>> connectionBlocks = this.getAllOption("connection", 1, 1);
        if (np.mConnections.length > 0 && connectionBlocks != null) {
            throw new ConfigParseError("Using a <connection> block and --remote is not allowed.");
        }
        if (connectionBlocks != null) {
            np.mConnections = new Connection[connectionBlocks.size()];
            int connIndex = 0;
            for (Vector<String> conn : connectionBlocks) {
                Pair<Connection, Connection[]> connectionBlockConnection = this.parseConnection(conn.get(1), (Connection)conns.first);
                if (((Connection[])connectionBlockConnection.second).length != 1) {
                    throw new ConfigParseError("A <connection> block must have exactly one remote");
                }
                np.mConnections[connIndex] = ((Connection[])connectionBlockConnection.second)[0];
                ++connIndex;
            }
        }
        if (this.getOption("remote-random", 0, 0) != null) {
            np.mRemoteRandom = true;
        }
        if ((protoforce = this.getOption("proto-force", 1, 1)) != null) {
            boolean disableUDP;
            Connection[] protoToDisable;
            switch (protoToDisable = protoforce.get(1)) {
                case "udp": {
                    disableUDP = true;
                    break;
                }
                case "tcp": {
                    disableUDP = false;
                    break;
                }
                default: {
                    throw new ConfigParseError(String.format("Unknown protocol %s in proto-force", new Object[]{protoToDisable}));
                }
            }
            for (Connection conn : np.mConnections) {
                if (conn.mUseUdp != disableUDP) continue;
                conn.mEnabled = false;
            }
        }
        if ((friendlyname = this.meta.get("FRIENDLY_NAME")) != null && friendlyname.size() > 1) {
            np.mName = friendlyname.get(1);
        }
        if ((ocusername = this.meta.get("USERNAME")) != null && ocusername.size() > 1) {
            np.mUsername = ocusername.get(1);
        }
        this.checkIgnoreAndInvalidOptions(np);
        this.fixup(np);
        return np;
    }

    private Pair<Connection, Connection[]> parseConnection(String connection, Connection defaultValues) throws IOException, ConfigParseError {
        ConfigParser connectionParser = new ConfigParser();
        StringReader reader = new StringReader(connection.substring("[[INLINE]]".length()));
        connectionParser.parseConfig(reader);
        return connectionParser.parseConnectionOptions(defaultValues);
    }

    private Pair<Connection, Connection[]> parseConnectionOptions(Connection connDefault) throws ConfigParseError {
        Vector<String> connectTimeout;
        Vector<String> proto;
        Vector<String> rport;
        Connection conn;
        if (connDefault != null) {
            try {
                conn = connDefault.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
                return null;
            }
        } else {
            conn = new Connection();
        }
        Vector<String> port = this.getOption("port", 1, 1);
        if (port != null) {
            conn.mServerPort = port.get(1);
        }
        if ((rport = this.getOption("rport", 1, 1)) != null) {
            conn.mServerPort = rport.get(1);
        }
        if ((proto = this.getOption("proto", 1, 1)) != null) {
            conn.mUseUdp = this.isUdpProto(proto.get(1));
        }
        if ((connectTimeout = this.getOption("connect-timeout", 1, 1)) != null) {
            try {
                conn.mConnectTimeout = Integer.parseInt(connectTimeout.get(1));
            }
            catch (NumberFormatException nfe) {
                throw new ConfigParseError(String.format("Argument to connect-timeout (%s) must to be an integer: %s", connectTimeout.get(1), nfe.getLocalizedMessage()));
            }
        }
        Vector<Vector<String>> remotes = this.getAllOption("remote", 1, 3);
        if (connDefault != null) {
            for (Vector<Vector<String>> option : this.options.values()) {
                conn.mCustomConfiguration = conn.mCustomConfiguration + this.getOptionStrings(option);
            }
            if (!TextUtils.isEmpty((CharSequence)conn.mCustomConfiguration)) {
                conn.mUseCustomConfig = true;
            }
        }
        if (remotes == null) {
            remotes = new Vector();
        }
        Connection[] connections = new Connection[remotes.size()];
        int i = 0;
        for (Vector<String> remote : remotes) {
            try {
                connections[i] = conn.clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            switch (remote.size()) {
                case 4: {
                    connections[i].mUseUdp = this.isUdpProto(remote.get(3));
                }
                case 3: {
                    connections[i].mServerPort = remote.get(2);
                }
                case 2: {
                    connections[i].mServerName = remote.get(1);
                }
            }
            ++i;
        }
        return Pair.create((Object)conn, (Object)connections);
    }

    private void checkRedirectParameters(VpnProfile np, Vector<Vector<String>> defgw) {
        for (Vector<String> redirect : defgw) {
            for (int i = 1; i < redirect.size(); ++i) {
                if (redirect.get(i).equals("block-local")) {
                    np.mAllowLocalLAN = false;
                    continue;
                }
                if (!redirect.get(i).equals("unblock-local")) continue;
                np.mAllowLocalLAN = true;
            }
        }
    }

    private boolean isUdpProto(String proto) throws ConfigParseError {
        boolean isudp;
        if (proto.equals("udp") || proto.equals("udp6")) {
            isudp = true;
        } else if (proto.equals("tcp-client") || proto.equals("tcp") || proto.equals("tcp6") || proto.endsWith("tcp6-client")) {
            isudp = false;
        } else {
            throw new ConfigParseError("Unsupported option to --proto " + proto);
        }
        return isudp;
    }

    private void checkIgnoreAndInvalidOptions(VpnProfile np) throws ConfigParseError {
        for (String option : this.unsupportedOptions) {
            if (!this.options.containsKey(option)) continue;
            throw new ConfigParseError(String.format("Unsupported Option %s encountered in config file. Aborting", option));
        }
        for (String option : this.ignoreOptions) {
            this.options.remove(option);
        }
        if (this.options.size() > 0) {
            np.mCustomConfigOptions = "# These options found in the config file do not map to config settings:\n" + np.mCustomConfigOptions;
            for (Vector vector : this.options.values()) {
                np.mCustomConfigOptions = np.mCustomConfigOptions + this.getOptionStrings(vector);
            }
            np.mUseCustomConfig = true;
        }
    }

    private boolean ignoreThisOption(Vector<String> option) {
        for (String[] ignoreOption : this.ignoreOptionsWithArg) {
            if (option.size() < ignoreOption.length) continue;
            boolean ignore = true;
            for (int i = 0; i < ignoreOption.length; ++i) {
                if (ignoreOption[i].equals(option.get(i))) continue;
                ignore = false;
            }
            if (!ignore) continue;
            return true;
        }
        return false;
    }

    private String getOptionStrings(Vector<Vector<String>> option) {
        String custom = "";
        for (Vector<String> optionsline : option) {
            if (this.ignoreThisOption(optionsline)) continue;
            if (optionsline.size() == 2 && ("extra-certs".equals(optionsline.get(0)) || "http-proxy-user-pass".equals(optionsline.get(0)))) {
                custom = custom + VpnProfile.insertFileData(optionsline.get(0), optionsline.get(1));
                continue;
            }
            for (String arg : optionsline) {
                custom = custom + VpnProfile.openVpnEscape(arg) + " ";
            }
            custom = custom + "\n";
        }
        return custom;
    }

    private void fixup(VpnProfile np) {
        if (np.mRemoteCN.equals(np.mServerName)) {
            np.mRemoteCN = "";
        }
    }

    private Vector<String> getOption(String option, int minarg, int maxarg) throws ConfigParseError {
        Vector<Vector<String>> alloptions = this.getAllOption(option, minarg, maxarg);
        if (alloptions == null) {
            return null;
        }
        return alloptions.lastElement();
    }

    private Vector<Vector<String>> getAllOption(String option, int minarg, int maxarg) throws ConfigParseError {
        Vector<Vector<String>> args = this.options.get(option);
        if (args == null) {
            return null;
        }
        for (Vector<String> optionline : args) {
            if (optionline.size() >= minarg + 1 && optionline.size() <= maxarg + 1) continue;
            String err = String.format(Locale.getDefault(), "Option %s has %d parameters, expected between %d and %d", option, optionline.size() - 1, minarg, maxarg);
            throw new ConfigParseError(err);
        }
        this.options.remove(option);
        return args;
    }

    public static class ConfigParseError
    extends Exception {
        private static final long serialVersionUID = -60L;

        ConfigParseError(String msg) {
            super(msg);
        }
    }

    private static enum linestate {
        initial,
        readin_single_quote,
        reading_quoted,
        reading_unquoted,
        done;

    }
}

