/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn.core;

import java.util.Locale;

class CIDRIP {
    String mIp;
    int len;

    public CIDRIP(String ip, String mask) {
        this.mIp = ip;
        long netmask = CIDRIP.getInt(mask);
        netmask += 0x100000000L;
        int lenZeros = 0;
        while ((netmask & 1L) == 0L) {
            ++lenZeros;
            netmask >>= 1;
        }
        this.len = netmask != 0x1FFFFFFFFL >> lenZeros ? 32 : 32 - lenZeros;
    }

    public CIDRIP(String address, int prefix_length) {
        this.len = prefix_length;
        this.mIp = address;
    }

    static long getInt(String ipaddr) {
        String[] ipt = ipaddr.split("\\.");
        long ip = 0L;
        ip += Long.parseLong(ipt[0]) << 24;
        ip += (long)(Integer.parseInt(ipt[1]) << 16);
        ip += (long)(Integer.parseInt(ipt[2]) << 8);
        return ip += (long)Integer.parseInt(ipt[3]);
    }

    public String toString() {
        return String.format(Locale.ENGLISH, "%s/%d", this.mIp, this.len);
    }

    public boolean normalise() {
        long ip = CIDRIP.getInt(this.mIp);
        long newip = ip & 0xFFFFFFFFL << 32 - this.len;
        if (newip != ip) {
            this.mIp = String.format("%d.%d.%d.%d", (newip & 0xFFFFFFFFFF000000L) >> 24, (newip & 0xFF0000L) >> 16, (newip & 0xFF00L) >> 8, newip & 0xFFL);
            return true;
        }
        return false;
    }

    public long getInt() {
        return CIDRIP.getInt(this.mIp);
    }
}

