/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn.core;

import android.text.TextUtils;
import java.io.Serializable;

public class Connection
implements Serializable,
Cloneable {
    public static final int CONNECTION_DEFAULT_TIMEOUT = 120;
    private static final long serialVersionUID = 92031902903829089L;
    public String mServerName = "openvpn.blinkt.de";
    public String mServerPort = "1194";
    public boolean mUseUdp = true;
    public String mCustomConfiguration = "";
    public boolean mUseCustomConfig = false;
    public boolean mEnabled = true;
    public int mConnectTimeout = 0;

    public String getConnectionBlock() {
        String cfg = "";
        cfg = cfg + "remote ";
        cfg = cfg + this.mServerName;
        cfg = cfg + " ";
        cfg = cfg + this.mServerPort;
        cfg = this.mUseUdp ? cfg + " udp\n" : cfg + " tcp-client\n";
        if (this.mConnectTimeout != 0) {
            cfg = cfg + String.format(" connect-timeout  %d\n", this.mConnectTimeout);
        }
        if (!TextUtils.isEmpty((CharSequence)this.mCustomConfiguration) && this.mUseCustomConfig) {
            cfg = cfg + this.mCustomConfiguration;
            cfg = cfg + "\n";
        }
        return cfg;
    }

    public Connection clone() throws CloneNotSupportedException {
        return (Connection)super.clone();
    }

    public boolean isOnlyRemote() {
        return TextUtils.isEmpty((CharSequence)this.mCustomConfiguration) || !this.mUseCustomConfig;
    }

    public int getTimeout() {
        if (this.mConnectTimeout <= 0) {
            return 120;
        }
        return this.mConnectTimeout;
    }
}

