/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.Log;
import de.blinkt.openvpn.R;
import de.blinkt.openvpn.core.LogItem;
import de.blinkt.openvpn.core.OpenVPNService;
import de.blinkt.openvpn.core.VPNLaunchHelper;
import de.blinkt.openvpn.core.VpnStatus;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OpenVPNThread
implements Runnable {
    public static final int M_FATAL = 16;
    public static final int M_NONFATAL = 32;
    public static final int M_WARN = 64;
    public static final int M_DEBUG = 128;
    private static final String DUMP_PATH_STRING = "Dump path: ";
    @SuppressLint(value={"SdCardPath"})
    private static final String BROKEN_PIE_SUPPORT = "/data/data/de.blinkt.openvpn/cache/pievpn";
    private static final String BROKEN_PIE_SUPPORT2 = "syntax error";
    private static final String TAG = "OpenVPN";
    private String[] mArgv;
    private Process mProcess;
    private String mNativeDir;
    private OpenVPNService mService;
    private String mDumpPath;
    private boolean mBrokenPie = false;
    private boolean mNoProcessExitStatus = false;

    public OpenVPNThread(OpenVPNService service, String[] argv, String nativelibdir) {
        this.mArgv = argv;
        this.mNativeDir = nativelibdir;
        this.mService = service;
    }

    public void stopProcess() {
        this.mProcess.destroy();
    }

    void setReplaceConnection() {
        this.mNoProcessExitStatus = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Log.i((String)TAG, (String)"Starting openvpn");
            this.startOpenVPNThreadArgs(this.mArgv);
            Log.i((String)TAG, (String)"OpenVPN process exited");
        }
        catch (Exception e) {
            VpnStatus.logException("Starting OpenVPN Thread", e);
            Log.e((String)TAG, (String)("OpenVPNThread Got " + e.toString()));
        }
        finally {
            int exitvalue = 0;
            try {
                if (this.mProcess != null) {
                    exitvalue = this.mProcess.waitFor();
                }
            }
            catch (IllegalThreadStateException ite) {
                VpnStatus.logError("Illegal Thread state: " + ite.getLocalizedMessage());
            }
            catch (InterruptedException ie) {
                VpnStatus.logError("InterruptedException: " + ie.getLocalizedMessage());
            }
            if (exitvalue != 0) {
                String[] noPieArgv;
                VpnStatus.logError("Process exited with exit value " + exitvalue);
                if (this.mBrokenPie && !(noPieArgv = VPNLaunchHelper.replacePieWithNoPie(this.mArgv)).equals(this.mArgv)) {
                    this.mArgv = noPieArgv;
                    VpnStatus.logInfo("PIE Version could not be executed. Trying no PIE version");
                    this.run();
                    return;
                }
            }
            if (!this.mNoProcessExitStatus) {
                VpnStatus.updateStateString("NOPROCESS", "No process running.", R.string.state_noprocess, VpnStatus.ConnectionStatus.LEVEL_NOTCONNECTED);
            }
            if (this.mDumpPath != null) {
                try {
                    BufferedWriter logout = new BufferedWriter(new FileWriter(this.mDumpPath + ".log"));
                    SimpleDateFormat timeformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.GERMAN);
                    for (LogItem li : VpnStatus.getlogbuffer()) {
                        String time = timeformat.format(new Date(li.getLogtime()));
                        logout.write(time + " " + li.getString((Context)this.mService) + "\n");
                    }
                    logout.close();
                    VpnStatus.logError(R.string.minidump_generated);
                }
                catch (IOException e) {
                    VpnStatus.logError("Writing minidump log: " + e.getLocalizedMessage());
                }
            }
            this.mService.processDied();
            Log.i((String)TAG, (String)"Exiting");
        }
    }

    private void startOpenVPNThreadArgs(String[] argv) {
        LinkedList<String> argvlist = new LinkedList<String>();
        Collections.addAll(argvlist, argv);
        ProcessBuilder pb = new ProcessBuilder(argvlist);
        String lbpath = this.genLibraryPath(argv, pb);
        pb.environment().put("LD_LIBRARY_PATH", lbpath);
        pb.redirectErrorStream(true);
        try {
            this.mProcess = pb.start();
            this.mProcess.getOutputStream().close();
            InputStream in = this.mProcess.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            do {
                Pattern p;
                Matcher m;
                String logline;
                if ((logline = br.readLine()) == null) {
                    return;
                }
                if (logline.startsWith(DUMP_PATH_STRING)) {
                    this.mDumpPath = logline.substring(DUMP_PATH_STRING.length());
                }
                if (logline.startsWith(BROKEN_PIE_SUPPORT) || logline.contains(BROKEN_PIE_SUPPORT2)) {
                    this.mBrokenPie = true;
                }
                if ((m = (p = Pattern.compile("(\\d+).(\\d+) ([0-9a-f])+ (.*)")).matcher(logline)).matches()) {
                    int flags = Integer.parseInt(m.group(3), 16);
                    String msg = m.group(4);
                    int logLevel = flags & 0xF;
                    VpnStatus.LogLevel logStatus = VpnStatus.LogLevel.INFO;
                    if ((flags & 0x10) != 0) {
                        logStatus = VpnStatus.LogLevel.ERROR;
                    } else if ((flags & 0x20) != 0) {
                        logStatus = VpnStatus.LogLevel.WARNING;
                    } else if ((flags & 0x40) != 0) {
                        logStatus = VpnStatus.LogLevel.WARNING;
                    } else if ((flags & 0x80) != 0) {
                        logStatus = VpnStatus.LogLevel.VERBOSE;
                    }
                    if (msg.startsWith("MANAGEMENT: CMD")) {
                        logLevel = Math.max(4, logLevel);
                    }
                    VpnStatus.logMessageOpenVPN(logStatus, logLevel, msg);
                    continue;
                }
                VpnStatus.logInfo("P:" + logline);
            } while (!Thread.interrupted());
            throw new InterruptedException("OpenVpn process was killed form java code");
        }
        catch (IOException | InterruptedException e) {
            VpnStatus.logException("Error reading from output of OpenVPN process", e);
            this.stopProcess();
            return;
        }
    }

    private String genLibraryPath(String[] argv, ProcessBuilder pb) {
        String applibpath = argv[0].replaceFirst("/cache/.*$", "/lib");
        String lbpath = pb.environment().get("LD_LIBRARY_PATH");
        lbpath = lbpath == null ? applibpath : applibpath + ":" + lbpath;
        if (!applibpath.equals(this.mNativeDir)) {
            lbpath = this.mNativeDir + ":" + lbpath;
        }
        return lbpath;
    }
}

