/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.util.Log;
import de.blinkt.openvpn.R;
import de.blinkt.openvpn.core.OpenVPNManagement;
import de.blinkt.openvpn.core.OpenVPNService;
import de.blinkt.openvpn.core.ProfileManager;
import de.blinkt.openvpn.core.VpnStatus;
import java.util.LinkedList;

public class DeviceStateReceiver
extends BroadcastReceiver
implements VpnStatus.ByteCountListener,
OpenVPNManagement.PausedStateCallback {
    private final Handler mDisconnectHandler;
    private final int TRAFFIC_WINDOW = 60;
    private final long TRAFFIC_LIMIT = 65536L;
    private final int DISCONNECT_WAIT = 20;
    connectState network = connectState.DISCONNECTED;
    connectState screen = connectState.SHOULDBECONNECTED;
    connectState userpause = connectState.SHOULDBECONNECTED;
    LinkedList<Datapoint> trafficdata = new LinkedList();
    private int lastNetwork = -1;
    private OpenVPNManagement mManagement;
    private String lastStateMsg = null;
    private Runnable mDelayDisconnectRunnable = new Runnable(){

        @Override
        public void run() {
            if (DeviceStateReceiver.this.network != connectState.PENDINGDISCONNECT) {
                return;
            }
            DeviceStateReceiver.this.network = connectState.DISCONNECTED;
            if (DeviceStateReceiver.this.screen == connectState.PENDINGDISCONNECT) {
                DeviceStateReceiver.this.screen = connectState.DISCONNECTED;
            }
            DeviceStateReceiver.this.mManagement.pause(DeviceStateReceiver.this.getPauseReason());
        }
    };
    private NetworkInfo lastConnectedNetwork;

    public DeviceStateReceiver(OpenVPNManagement magnagement) {
        this.mManagement = magnagement;
        this.mManagement.setPauseCallback(this);
        this.mDisconnectHandler = new Handler();
    }

    public static boolean equalsObj(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    @Override
    public boolean shouldBeRunning() {
        return this.shouldBeConnected();
    }

    @Override
    public void updateByteCount(long in, long out, long diffIn, long diffOut) {
        if (this.screen != connectState.PENDINGDISCONNECT) {
            return;
        }
        long total = diffIn + diffOut;
        this.trafficdata.add(new Datapoint(System.currentTimeMillis(), total));
        while (this.trafficdata.getFirst().timestamp <= System.currentTimeMillis() - 60000L) {
            this.trafficdata.removeFirst();
        }
        long windowtraffic = 0L;
        for (Datapoint dp : this.trafficdata) {
            windowtraffic += dp.data;
        }
        if (windowtraffic < 65536L) {
            this.screen = connectState.DISCONNECTED;
            VpnStatus.logInfo(R.string.screenoff_pause, OpenVPNService.humanReadableByteCount(65536L, false), 60);
            this.mManagement.pause(this.getPauseReason());
        }
    }

    public void userPause(boolean pause) {
        if (pause) {
            this.userpause = connectState.DISCONNECTED;
            this.mManagement.pause(this.getPauseReason());
        } else {
            boolean wereConnected = this.shouldBeConnected();
            this.userpause = connectState.SHOULDBECONNECTED;
            if (this.shouldBeConnected() && !wereConnected) {
                this.mManagement.resume();
            } else {
                this.mManagement.pause(this.getPauseReason());
            }
        }
    }

    public void onReceive(Context context, Intent intent) {
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            this.networkStateChange(context);
        } else if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
            boolean screenOffPause = prefs.getBoolean("screenoff", false);
            if (screenOffPause) {
                if (ProfileManager.getLastConnectedVpn() != null && !ProfileManager.getLastConnectedVpn().mPersistTun) {
                    VpnStatus.logError(R.string.screen_nopersistenttun);
                }
                this.screen = connectState.PENDINGDISCONNECT;
                this.fillTrafficData();
                if (this.network == connectState.DISCONNECTED || this.userpause == connectState.DISCONNECTED) {
                    this.screen = connectState.DISCONNECTED;
                }
            }
        } else if ("android.intent.action.SCREEN_ON".equals(intent.getAction())) {
            boolean connected = this.shouldBeConnected();
            this.screen = connectState.SHOULDBECONNECTED;
            this.mDisconnectHandler.removeCallbacks(this.mDelayDisconnectRunnable);
            if (this.shouldBeConnected() != connected) {
                this.mManagement.resume();
            } else if (!this.shouldBeConnected()) {
                this.mManagement.pause(this.getPauseReason());
            }
        }
    }

    private void fillTrafficData() {
        this.trafficdata.add(new Datapoint(System.currentTimeMillis(), 65536L));
    }

    public void networkStateChange(Context context) {
        String netstatestring;
        NetworkInfo networkInfo = this.getCurrentNetworkInfo(context);
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)context);
        boolean sendusr1 = prefs.getBoolean("netchangereconnect", true);
        if (networkInfo == null) {
            netstatestring = "not connected";
        } else {
            String extrainfo;
            String subtype = networkInfo.getSubtypeName();
            if (subtype == null) {
                subtype = "";
            }
            if ((extrainfo = networkInfo.getExtraInfo()) == null) {
                extrainfo = "";
            }
            netstatestring = String.format("%2$s %4$s to %1$s %3$s", networkInfo.getTypeName(), networkInfo.getDetailedState(), extrainfo, subtype);
        }
        if (networkInfo != null && networkInfo.getState() == NetworkInfo.State.CONNECTED) {
            int newnet = networkInfo.getType();
            boolean pendingDisconnect = this.network == connectState.PENDINGDISCONNECT;
            this.network = connectState.SHOULDBECONNECTED;
            boolean sameNetwork = this.lastConnectedNetwork != null && this.lastConnectedNetwork.getType() == networkInfo.getType() && DeviceStateReceiver.equalsObj(this.lastConnectedNetwork.getExtraInfo(), networkInfo.getExtraInfo());
            if (pendingDisconnect && sameNetwork) {
                this.mDisconnectHandler.removeCallbacks(this.mDelayDisconnectRunnable);
                this.mManagement.networkChange(true);
            } else {
                if (this.screen == connectState.PENDINGDISCONNECT) {
                    this.screen = connectState.DISCONNECTED;
                }
                if (this.shouldBeConnected()) {
                    this.mDisconnectHandler.removeCallbacks(this.mDelayDisconnectRunnable);
                    if (pendingDisconnect || !sameNetwork) {
                        this.mManagement.networkChange(sameNetwork);
                    } else {
                        this.mManagement.resume();
                    }
                }
                this.lastNetwork = newnet;
                this.lastConnectedNetwork = networkInfo;
            }
        } else if (networkInfo == null) {
            Log.v((String)"ttt net", (String)"not connected");
            this.lastNetwork = -1;
            if (sendusr1) {
                this.network = connectState.PENDINGDISCONNECT;
                this.mDisconnectHandler.postDelayed(this.mDelayDisconnectRunnable, 20000L);
            }
        }
        if (!netstatestring.equals(this.lastStateMsg)) {
            VpnStatus.logInfo(R.string.netstatus, netstatestring);
        }
        this.lastStateMsg = netstatestring;
    }

    public boolean isUserPaused() {
        return this.userpause == connectState.DISCONNECTED;
    }

    private boolean shouldBeConnected() {
        return this.screen == connectState.SHOULDBECONNECTED && this.userpause == connectState.SHOULDBECONNECTED && this.network == connectState.SHOULDBECONNECTED;
    }

    private OpenVPNManagement.pauseReason getPauseReason() {
        if (this.userpause == connectState.DISCONNECTED) {
            return OpenVPNManagement.pauseReason.userPause;
        }
        if (this.screen == connectState.DISCONNECTED) {
            return OpenVPNManagement.pauseReason.screenOff;
        }
        if (this.network == connectState.DISCONNECTED) {
            return OpenVPNManagement.pauseReason.noNetwork;
        }
        return OpenVPNManagement.pauseReason.userPause;
    }

    private NetworkInfo getCurrentNetworkInfo(Context context) {
        ConnectivityManager conn = (ConnectivityManager)context.getSystemService("connectivity");
        return conn.getActiveNetworkInfo();
    }

    static class Datapoint {
        long timestamp;
        long data;

        private Datapoint(long t, long d) {
            this.timestamp = t;
            this.data = d;
        }
    }

    static enum connectState {
        SHOULDBECONNECTED,
        PENDINGDISCONNECT,
        DISCONNECTED;

    }
}

