/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import de.blinkt.openvpn.R;
import de.blinkt.openvpn.core.OpenVPNService;
import de.blinkt.openvpn.core.ProfileManager;

public class DisconnectVPNActivity
extends Activity
implements DialogInterface.OnClickListener,
DialogInterface.OnCancelListener {
    protected OpenVPNService mService;
    private ServiceConnection mConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName className, IBinder service) {
            OpenVPNService.LocalBinder binder = (OpenVPNService.LocalBinder)service;
            DisconnectVPNActivity.this.mService = binder.getService();
        }

        public void onServiceDisconnected(ComponentName arg0) {
            DisconnectVPNActivity.this.mService = null;
        }
    };

    protected void onResume() {
        super.onResume();
        Intent intent = new Intent((Context)this, OpenVPNService.class);
        intent.setAction("de.blinkt.openvpn.START_SERVICE");
        this.bindService(intent, this.mConnection, 1);
        this.showDisconnectDialog();
    }

    protected void onPause() {
        super.onPause();
        this.unbindService(this.mConnection);
    }

    private void showDisconnectDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle(R.string.title_cancel);
        builder.setMessage(R.string.cancel_connection_query);
        builder.setNegativeButton(17039369, (DialogInterface.OnClickListener)this);
        builder.setPositiveButton(17039379, (DialogInterface.OnClickListener)this);
        builder.setOnCancelListener((DialogInterface.OnCancelListener)this);
        builder.show();
    }

    public void onClick(DialogInterface dialog, int which) {
        if (which == -1) {
            ProfileManager.setConntectedVpnProfileDisconnected((Context)this);
            if (this.mService != null && this.mService.getManagement() != null) {
                this.mService.getManagement().stopVPN(false);
            }
        }
        this.finish();
    }

    public void onCancel(DialogInterface dialog) {
        this.finish();
    }
}

