/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn.core;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import de.blinkt.openvpn.R;
import de.blinkt.openvpn.VpnProfile;
import de.blinkt.openvpn.core.NativeUtils;
import de.blinkt.openvpn.core.VpnStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Vector;

public class VPNLaunchHelper {
    private static final String MININONPIEVPN = "nopie_openvpn";
    private static final String MINIPIEVPN = "pie_openvpn";
    private static final String OVPNCONFIGFILE = "android.conf";

    private static String writeMiniVPN(Context context) {
        Object[] abis = Build.VERSION.SDK_INT >= 21 ? VPNLaunchHelper.getSupportedABIsLollipop() : new String[]{Build.CPU_ABI, Build.CPU_ABI2};
        String nativeAPI = NativeUtils.getNativeAPI();
        if (!nativeAPI.equals(abis[0])) {
            VpnStatus.logWarning(R.string.abi_mismatch, Arrays.toString(abis), nativeAPI);
            abis = new String[]{nativeAPI};
        }
        for (Object abi : abis) {
            File vpnExecutable = new File(context.getCacheDir(), VPNLaunchHelper.getMiniVPNExecutableName() + "." + (String)abi);
            if ((!vpnExecutable.exists() || !vpnExecutable.canExecute()) && !VPNLaunchHelper.writeMiniVPNBinary(context, (String)abi, vpnExecutable)) continue;
            return vpnExecutable.getPath();
        }
        return null;
    }

    @TargetApi(value=21)
    private static String[] getSupportedABIsLollipop() {
        return Build.SUPPORTED_ABIS;
    }

    private static String getMiniVPNExecutableName() {
        if (Build.VERSION.SDK_INT >= 16) {
            return MINIPIEVPN;
        }
        return MININONPIEVPN;
    }

    public static String[] replacePieWithNoPie(String[] mArgv) {
        mArgv[0] = mArgv[0].replace(MINIPIEVPN, MININONPIEVPN);
        return mArgv;
    }

    static String[] buildOpenvpnArgv(Context c) {
        Vector<String> args = new Vector<String>();
        String binaryName = VPNLaunchHelper.writeMiniVPN(c);
        if (binaryName == null) {
            VpnStatus.logError("Error writing minivpn binary");
            return null;
        }
        args.add(binaryName);
        args.add("--config");
        args.add(VPNLaunchHelper.getConfigFilePath(c));
        return args.toArray(new String[args.size()]);
    }

    private static boolean writeMiniVPNBinary(Context context, String abi, File mvpnout) {
        try {
            InputStream mvpn;
            try {
                mvpn = context.getAssets().open(VPNLaunchHelper.getMiniVPNExecutableName() + "." + abi);
            }
            catch (IOException errabi) {
                VpnStatus.logInfo("Failed getting assets for archicture " + abi);
                return false;
            }
            FileOutputStream fout = new FileOutputStream(mvpnout);
            byte[] buf = new byte[4096];
            int lenread = mvpn.read(buf);
            while (lenread > 0) {
                fout.write(buf, 0, lenread);
                lenread = mvpn.read(buf);
            }
            fout.close();
            if (!mvpnout.setExecutable(true)) {
                VpnStatus.logError("Failed to make OpenVPN executable");
                return false;
            }
            return true;
        }
        catch (IOException e) {
            VpnStatus.logException(e);
            return false;
        }
    }

    public static void startOpenVpn(VpnProfile startprofile, Context context) {
        Intent startVPN = startprofile.prepareStartService(context);
        if (startVPN != null) {
            context.startService(startVPN);
        }
    }

    public static String getConfigFilePath(Context context) {
        return context.getCacheDir().getAbsolutePath() + "/" + OVPNCONFIGFILE;
    }
}

