/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn.core;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Parcel;
import android.os.Parcelable;
import de.blinkt.openvpn.R;
import de.blinkt.openvpn.core.VpnStatus;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.FormatFlagsConversionMismatchException;
import java.util.Locale;
import java.util.UnknownFormatConversionException;

public class LogItem
implements Parcelable {
    public static final Parcelable.Creator<LogItem> CREATOR = new Parcelable.Creator<LogItem>(){

        public LogItem createFromParcel(Parcel in) {
            return new LogItem(in);
        }

        public LogItem[] newArray(int size) {
            return new LogItem[size];
        }
    };
    VpnStatus.LogLevel mLevel = VpnStatus.LogLevel.INFO;
    private Object[] mArgs = null;
    private String mMessage = null;
    private int mRessourceId;
    private long logtime = System.currentTimeMillis();
    private int mVerbosityLevel = -1;

    private LogItem(int ressourceId, Object[] args) {
        this.mRessourceId = ressourceId;
        this.mArgs = args;
    }

    public LogItem(VpnStatus.LogLevel level, int verblevel, String message) {
        this.mMessage = message;
        this.mLevel = level;
        this.mVerbosityLevel = verblevel;
    }

    public LogItem(byte[] in, int length) throws UnsupportedEncodingException {
        ByteBuffer bb = ByteBuffer.wrap(in, 0, length);
        bb.get();
        this.logtime = bb.getLong();
        this.mVerbosityLevel = bb.getInt();
        this.mLevel = VpnStatus.LogLevel.getEnumByValue(bb.getInt());
        this.mRessourceId = bb.getInt();
        int len = bb.getInt();
        if (len == 0) {
            this.mMessage = null;
        } else {
            if (len > bb.remaining()) {
                throw new IndexOutOfBoundsException("String length " + len + " is bigger than remaining bytes " + bb.remaining());
            }
            byte[] utf8bytes = new byte[len];
            bb.get(utf8bytes);
            this.mMessage = new String(utf8bytes, "UTF-8");
        }
        int numArgs = bb.getInt();
        if (numArgs > 30) {
            throw new IndexOutOfBoundsException("Too many arguments for Logitem to unmarschal");
        }
        if (numArgs == 0) {
            this.mArgs = null;
        } else {
            this.mArgs = new Object[numArgs];
            block8: for (int i = 0; i < numArgs; ++i) {
                char type = bb.getChar();
                switch (type) {
                    case 's': {
                        this.mArgs[i] = this.unmarschalString(bb);
                        continue block8;
                    }
                    case 'i': {
                        this.mArgs[i] = bb.getInt();
                        continue block8;
                    }
                    case 'd': {
                        this.mArgs[i] = bb.getDouble();
                        continue block8;
                    }
                    case 'f': {
                        this.mArgs[i] = Float.valueOf(bb.getFloat());
                        continue block8;
                    }
                    case 'l': {
                        this.mArgs[i] = bb.getLong();
                        continue block8;
                    }
                    case '0': {
                        this.mArgs[i] = null;
                        continue block8;
                    }
                    default: {
                        throw new UnsupportedEncodingException("Unknown format type: " + type);
                    }
                }
            }
        }
        if (bb.hasRemaining()) {
            throw new UnsupportedEncodingException(bb.remaining() + " bytes left after unmarshaling everything");
        }
    }

    public LogItem(Parcel in) {
        this.mArgs = in.readArray(Object.class.getClassLoader());
        this.mMessage = in.readString();
        this.mRessourceId = in.readInt();
        this.mLevel = VpnStatus.LogLevel.getEnumByValue(in.readInt());
        this.mVerbosityLevel = in.readInt();
        this.logtime = in.readLong();
    }

    public LogItem(VpnStatus.LogLevel loglevel, int ressourceId, Object ... args) {
        this.mRessourceId = ressourceId;
        this.mArgs = args;
        this.mLevel = loglevel;
    }

    public LogItem(VpnStatus.LogLevel loglevel, String msg) {
        this.mLevel = loglevel;
        this.mMessage = msg;
    }

    public LogItem(VpnStatus.LogLevel loglevel, int ressourceId) {
        this.mRessourceId = ressourceId;
        this.mLevel = loglevel;
    }

    public static String join(CharSequence delimiter, Object[] tokens) {
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (Object token : tokens) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeArray(this.mArgs);
        dest.writeString(this.mMessage);
        dest.writeInt(this.mRessourceId);
        dest.writeInt(this.mLevel.getInt());
        dest.writeInt(this.mVerbosityLevel);
        dest.writeLong(this.logtime);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LogItem)) {
            return obj.equals(this);
        }
        LogItem other = (LogItem)obj;
        return Arrays.equals(this.mArgs, other.mArgs) && (other.mMessage == null && this.mMessage == other.mMessage || this.mMessage.equals(other.mMessage)) && this.mRessourceId == other.mRessourceId && (this.mLevel == null && other.mLevel == this.mLevel || other.mLevel.equals((Object)this.mLevel)) && this.mVerbosityLevel == other.mVerbosityLevel && this.logtime == other.logtime;
    }

    public byte[] getMarschaledBytes() throws UnsupportedEncodingException, BufferOverflowException {
        ByteBuffer bb = ByteBuffer.allocate(16384);
        bb.put((byte)0);
        bb.putLong(this.logtime);
        bb.putInt(this.mVerbosityLevel);
        bb.putInt(this.mLevel.getInt());
        bb.putInt(this.mRessourceId);
        if (this.mMessage == null || this.mMessage.length() == 0) {
            bb.putInt(0);
        } else {
            this.marschalString(this.mMessage, bb);
        }
        if (this.mArgs == null || this.mArgs.length == 0) {
            bb.putInt(0);
        } else {
            bb.putInt(this.mArgs.length);
            for (Object o : this.mArgs) {
                if (o instanceof String) {
                    bb.putChar('s');
                    this.marschalString((String)o, bb);
                    continue;
                }
                if (o instanceof Integer) {
                    bb.putChar('i');
                    bb.putInt((Integer)o);
                    continue;
                }
                if (o instanceof Float) {
                    bb.putChar('f');
                    bb.putFloat(((Float)o).floatValue());
                    continue;
                }
                if (o instanceof Double) {
                    bb.putChar('d');
                    bb.putDouble((Double)o);
                    continue;
                }
                if (o instanceof Long) {
                    bb.putChar('l');
                    bb.putLong((Long)o);
                    continue;
                }
                if (o == null) {
                    bb.putChar('0');
                    continue;
                }
                VpnStatus.logDebug("Unknown object for LogItem marschaling " + o);
                bb.putChar('s');
                this.marschalString(o.toString(), bb);
            }
        }
        int pos = bb.position();
        bb.rewind();
        return Arrays.copyOf(bb.array(), pos);
    }

    private void marschalString(String str, ByteBuffer bb) throws UnsupportedEncodingException {
        byte[] utf8bytes = str.getBytes("UTF-8");
        bb.putInt(utf8bytes.length);
        bb.put(utf8bytes);
    }

    private String unmarschalString(ByteBuffer bb) throws UnsupportedEncodingException {
        int len = bb.getInt();
        byte[] utf8bytes = new byte[len];
        bb.get(utf8bytes);
        return new String(utf8bytes, "UTF-8");
    }

    public String getString(Context c) {
        try {
            if (this.mMessage != null) {
                return this.mMessage;
            }
            if (c != null) {
                if (this.mRessourceId == R.string.mobile_info) {
                    return this.getMobileInfoString(c);
                }
                if (this.mArgs == null) {
                    return c.getString(this.mRessourceId);
                }
                return c.getString(this.mRessourceId, this.mArgs);
            }
            String str = String.format(Locale.ENGLISH, "Log (no context) resid %d", this.mRessourceId);
            if (this.mArgs != null) {
                str = str + LogItem.join("|", this.mArgs);
            }
            return str;
        }
        catch (UnknownFormatConversionException e) {
            if (c != null) {
                throw new UnknownFormatConversionException(e.getLocalizedMessage() + this.getString(null));
            }
            throw e;
        }
        catch (FormatFlagsConversionMismatchException e) {
            if (c != null) {
                throw new FormatFlagsConversionMismatchException(e.getLocalizedMessage() + this.getString(null), e.getConversion());
            }
            throw e;
        }
    }

    public VpnStatus.LogLevel getLogLevel() {
        return this.mLevel;
    }

    public String toString() {
        return this.getString(null);
    }

    @SuppressLint(value={"StringFormatMatches"})
    private String getMobileInfoString(Context c) {
        c.getPackageManager();
        String apksign = "error getting package signature";
        String version = "error getting version";
        try {
            Signature raw = c.getPackageManager().getPackageInfo((String)c.getPackageName(), (int)64).signatures[0];
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(raw.toByteArray()));
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] der = cert.getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            apksign = Arrays.equals(digest, VpnStatus.officalkey) ? c.getString(R.string.official_build) : (Arrays.equals(digest, VpnStatus.officaldebugkey) ? c.getString(R.string.debug_build) : (Arrays.equals(digest, VpnStatus.amazonkey) ? "amazon version" : (Arrays.equals(digest, VpnStatus.fdroidkey) ? "F-Droid built and signed version" : c.getString(R.string.built_by, new Object[]{cert.getSubjectX500Principal().getName()}))));
            PackageInfo packageinfo = c.getPackageManager().getPackageInfo(c.getPackageName(), 0);
            version = packageinfo.versionName;
        }
        catch (PackageManager.NameNotFoundException | NoSuchAlgorithmException | CertificateException raw) {
            // empty catch block
        }
        Object[] argsext = Arrays.copyOf(this.mArgs, this.mArgs.length);
        argsext[argsext.length - 1] = apksign;
        argsext[argsext.length - 2] = version;
        return c.getString(R.string.mobile_info, argsext);
    }

    public long getLogtime() {
        return this.logtime;
    }

    public int getVerbosityLevel() {
        if (this.mVerbosityLevel == -1) {
            return this.mLevel.getInt();
        }
        return this.mVerbosityLevel;
    }

    public boolean verify() {
        if (this.mLevel == null) {
            return false;
        }
        return this.mMessage != null || this.mRessourceId != 0;
    }
}

