/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn.core;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import de.blinkt.openvpn.R;
import de.blinkt.openvpn.VpnProfile;
import de.blinkt.openvpn.core.VpnStatus;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.security.auth.x500.X500Principal;
import org.spongycastle.util.io.pem.PemObject;
import org.spongycastle.util.io.pem.PemReader;

public class X509Utils {
    public static Certificate[] getCertificatesFromFile(String certfilename) throws FileNotFoundException, CertificateException {
        CertificateFactory certFact = CertificateFactory.getInstance("X.509");
        Vector<Certificate> certificates = new Vector<Certificate>();
        if (VpnProfile.isEmbedded(certfilename)) {
            int subIndex = certfilename.indexOf("-----BEGIN CERTIFICATE-----");
            do {
                subIndex = Math.max(0, subIndex);
                ByteArrayInputStream inStream = new ByteArrayInputStream(certfilename.substring(subIndex).getBytes());
                certificates.add(certFact.generateCertificate(inStream));
            } while ((subIndex = certfilename.indexOf("-----BEGIN CERTIFICATE-----", subIndex + 1)) > 0);
            return certificates.toArray(new Certificate[certificates.size()]);
        }
        FileInputStream inStream = new FileInputStream(certfilename);
        return new Certificate[]{certFact.generateCertificate(inStream)};
    }

    public static PemObject readPemObjectFromFile(String keyfilename) throws IOException {
        Reader inStream = VpnProfile.isEmbedded(keyfilename) ? new StringReader(VpnProfile.getEmbeddedContent(keyfilename)) : new FileReader(new File(keyfilename));
        PemReader pr = new PemReader(inStream);
        PemObject r = pr.readPemObject();
        pr.close();
        return r;
    }

    public static String getCertificateFriendlyName(Context c, String filename) {
        if (!TextUtils.isEmpty((CharSequence)filename)) {
            try {
                X509Certificate cert = (X509Certificate)X509Utils.getCertificatesFromFile(filename)[0];
                String friendlycn = X509Utils.getCertificateFriendlyName(cert);
                friendlycn = X509Utils.getCertificateValidityString(cert, c.getResources()) + friendlycn;
                return friendlycn;
            }
            catch (Exception e) {
                VpnStatus.logError("Could not read certificate" + e.getLocalizedMessage());
            }
        }
        return c.getString(R.string.cannotparsecert);
    }

    public static String getCertificateValidityString(X509Certificate cert, Resources res) {
        try {
            cert.checkValidity();
        }
        catch (CertificateExpiredException ce) {
            return "EXPIRED: ";
        }
        catch (CertificateNotYetValidException cny) {
            return "NOT YET VALID: ";
        }
        Date certNotAfter = cert.getNotAfter();
        Date now = new Date();
        long timeLeft = certNotAfter.getTime() - now.getTime();
        if (timeLeft > 7776000000L) {
            long months = X509Utils.getMonthsDifference(now, certNotAfter);
            return res.getString(R.string.months_left, new Object[]{months});
        }
        if (timeLeft > 259200000L) {
            long days = timeLeft / 86400000L;
            return res.getString(R.string.days_left, new Object[]{days});
        }
        long hours = timeLeft / 3600000L;
        return res.getString(R.string.hours_left, new Object[]{hours});
    }

    public static int getMonthsDifference(Date date1, Date date2) {
        int m1 = date1.getYear() * 12 + date1.getMonth();
        int m2 = date2.getYear() * 12 + date2.getMonth();
        return m2 - m1 + 1;
    }

    public static String getCertificateFriendlyName(X509Certificate cert) {
        X500Principal principal = cert.getSubjectX500Principal();
        byte[] encodedSubject = principal.getEncoded();
        String friendlyName = null;
        ReflectiveOperationException exp = null;
        try {
            Class<?> X509NameClass = Class.forName("com.android.org.bouncycastle.asn1.x509.X509Name");
            Method getInstance = X509NameClass.getMethod("getInstance", Object.class);
            Hashtable defaultSymbols = (Hashtable)X509NameClass.getField("DefaultSymbols").get(X509NameClass);
            if (!defaultSymbols.containsKey("1.2.840.113549.1.9.1")) {
                defaultSymbols.put("1.2.840.113549.1.9.1", "eMail");
            }
            Object subjectName = getInstance.invoke(X509NameClass, new Object[]{encodedSubject});
            Method toString = X509NameClass.getMethod("toString", Boolean.TYPE, Hashtable.class);
            friendlyName = (String)toString.invoke(subjectName, true, defaultSymbols);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            exp = e;
        }
        if (exp != null) {
            VpnStatus.logException("Getting X509 Name from certificate", exp);
        }
        if (friendlyName == null) {
            friendlyName = principal.getName();
        }
        Object[] parts = friendlyName.split(",");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (!part.startsWith("1.2.840.113549.1.9.1=#16")) continue;
            parts[i] = "email=" + X509Utils.ia5decode(part.replace("1.2.840.113549.1.9.1=#16", ""));
        }
        friendlyName = TextUtils.join((CharSequence)",", (Object[])parts);
        return friendlyName;
    }

    private static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    private static String ia5decode(String ia5string) {
        String d = "";
        for (int i = 1; i < ia5string.length(); i += 2) {
            String hexstr = ia5string.substring(i - 1, i + 1);
            char c = (char)Integer.parseInt(hexstr, 16);
            if (X509Utils.isPrintableChar(c)) {
                d = d + c;
                continue;
            }
            if (i == 1 && (c == '\u0012' || c == '\u001b')) continue;
            d = d + "\\x" + hexstr;
        }
        return d;
    }
}

