/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn;

import android.content.Context;
import android.content.Intent;
import android.net.VpnService;
import android.os.RemoteException;
import android.text.TextUtils;
import de.blinkt.openvpn.R;
import de.blinkt.openvpn.VpnAuthActivity;
import de.blinkt.openvpn.VpnProfile;
import de.blinkt.openvpn.core.ConfigParser;
import de.blinkt.openvpn.core.ProfileManager;
import de.blinkt.openvpn.core.VPNLaunchHelper;
import java.io.IOException;
import java.io.StringReader;

public class OpenVpnApi {
    public static void startVpn(Context context, String inlineConfig, String userName, String pw, String country, String mServerPort, String mDNS1) throws RemoteException {
        if (TextUtils.isEmpty((CharSequence)inlineConfig)) {
            throw new RemoteException("config is empty");
        }
        Intent intent = VpnService.prepare((Context)context);
        if (intent != null) {
            intent = new Intent(context, VpnAuthActivity.class);
            intent.putExtra("config", inlineConfig);
            if (!TextUtils.isEmpty((CharSequence)userName)) {
                intent.putExtra("username", userName);
            }
            if (!TextUtils.isEmpty((CharSequence)pw)) {
                intent.putExtra("password", pw);
            }
            if (!TextUtils.isEmpty((CharSequence)country)) {
                intent.putExtra("country", country);
            }
            if (!TextUtils.isEmpty((CharSequence)mServerPort)) {
                intent.putExtra("port", mServerPort);
            }
            if (!TextUtils.isEmpty((CharSequence)mDNS1)) {
                intent.putExtra("dns", mDNS1);
            }
            context.startActivity(intent);
        } else {
            OpenVpnApi.startVpnInternal(context, inlineConfig, userName, pw, country, mServerPort, mDNS1);
        }
    }

    static void startVpnInternal(Context context, String inlineConfig, String userName, String pw, String country, String mServerPort, String mDNS1) throws RemoteException {
        ConfigParser cp = new ConfigParser();
        try {
            cp.parseConfig(new StringReader(inlineConfig));
            VpnProfile vp = cp.convertProfile();
            vp.mName = country;
            vp.mProfileCreator = context.getPackageName();
            vp.mUsername = userName;
            vp.mPassword = pw;
            vp.mServerPort = mServerPort;
            vp.mDNS1 = mDNS1;
            if (vp.checkProfile(context) != R.string.no_error_found) {
                throw new RemoteException(context.getString(vp.checkProfile(context)));
            }
            ProfileManager.setTemporaryProfile(vp);
            VPNLaunchHelper.startOpenVpn(vp, context);
        }
        catch (ConfigParser.ConfigParseError | IOException e) {
            throw new RemoteException(e.getMessage());
        }
    }
}

