/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn.core;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import de.blinkt.openvpn.R;
import de.blinkt.openvpn.core.LogItem;
import de.blinkt.openvpn.core.VpnStatus;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Locale;

class LogFileHandler
extends Handler {
    public static final int LOG_MESSAGE = 103;
    public static final int MAGIC_BYTE = 85;
    public static final String LOGFILE_NAME = "logcache.dat";
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    static final int TRIM_LOG_FILE = 100;
    static final int FLUSH_TO_DISK = 101;
    static final int LOG_INIT = 102;
    protected OutputStream mLogFile;

    public LogFileHandler(Looper looper) {
        super(looper);
    }

    public static String bytesToHex(byte[] bytes, int len) {
        len = Math.min(bytes.length, len);
        char[] hexChars = new char[len * 2];
        for (int j = 0; j < len; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public void handleMessage(Message msg) {
        try {
            if (msg.what == 102) {
                if (this.mLogFile != null) {
                    throw new RuntimeException("mLogFile not null");
                }
                this.readLogCache((File)msg.obj);
                this.openLogFile((File)msg.obj);
            } else if (msg.what == 103 && msg.obj instanceof LogItem) {
                if (this.mLogFile == null) {
                    return;
                }
                this.writeLogItemToDisk((LogItem)msg.obj);
            } else if (msg.what == 100) {
                this.trimLogFile();
                for (LogItem li : VpnStatus.getlogbuffer()) {
                    this.writeLogItemToDisk(li);
                }
            } else if (msg.what == 101) {
                this.flushToDisk();
            }
        }
        catch (IOException | BufferOverflowException e) {
            e.printStackTrace();
            VpnStatus.logError("Error during log cache: " + msg.what);
            VpnStatus.logException(e);
        }
    }

    private void flushToDisk() throws IOException {
        this.mLogFile.flush();
    }

    private void trimLogFile() {
        try {
            this.mLogFile.flush();
            ((FileOutputStream)this.mLogFile).getChannel().truncate(0L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeLogItemToDisk(LogItem li) throws IOException {
        byte[] liBytes = li.getMarschaledBytes();
        this.writeEscapedBytes(liBytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEscapedBytes(byte[] bytes) throws IOException {
        int magic = 0;
        for (byte b : bytes) {
            if (b != 85 && b != 86) continue;
            ++magic;
        }
        byte[] eBytes = new byte[bytes.length + magic];
        int i = 0;
        for (byte b : bytes) {
            if (b == 85 || b == 86) {
                eBytes[i++] = 86;
                eBytes[i++] = (byte)(b - 85);
                continue;
            }
            eBytes[i++] = b;
        }
        byte[] lenBytes = ByteBuffer.allocate(4).putInt(bytes.length).array();
        OutputStream outputStream = this.mLogFile;
        synchronized (outputStream) {
            this.mLogFile.write(85);
            this.mLogFile.write(lenBytes);
            this.mLogFile.write(eBytes);
        }
    }

    private void openLogFile(File cacheDir) throws FileNotFoundException {
        File logfile = new File(cacheDir, LOGFILE_NAME);
        this.mLogFile = new FileOutputStream(logfile);
    }

    private void readLogCache(File cacheDir) {
        try {
            File logfile = new File(cacheDir, LOGFILE_NAME);
            if (!logfile.exists() || !logfile.canRead()) {
                return;
            }
            this.readCacheContents(new FileInputStream(logfile));
        }
        catch (IOException | RuntimeException e) {
            VpnStatus.logError("Reading cached logfile failed");
            VpnStatus.logException(e);
            e.printStackTrace();
        }
    }

    protected void readCacheContents(InputStream in) throws IOException {
        BufferedInputStream logFile = new BufferedInputStream(in);
        byte[] buf = new byte[16384];
        int read = logFile.read(buf, 0, 5);
        int itemsRead = 0;
        block0: while (read >= 5) {
            int skipped = 0;
            while (buf[skipped] != 85) {
                if (logFile.read(buf, ++skipped + 4, 1) == 1 && skipped + 10 <= buf.length) continue;
                VpnStatus.logDebug(String.format(Locale.US, "Skipped %d bytes and no a magic byte found", skipped));
                break block0;
            }
            if (skipped > 0) {
                VpnStatus.logDebug(String.format(Locale.US, "Skipped %d bytes before finding a magic byte", skipped));
            }
            int len = ByteBuffer.wrap(buf, skipped + 1, 4).asIntBuffer().get();
            int pos = 0;
            byte[] buf2 = new byte[buf.length];
            while (pos < len) {
                byte b = (byte)logFile.read();
                if (b == 85) {
                    VpnStatus.logDebug(String.format(Locale.US, "Unexpected magic byte found at pos %d, abort current log item", pos));
                    read = logFile.read(buf, 1, 4) + 1;
                    continue block0;
                }
                if (b == 86) {
                    b = (byte)logFile.read();
                    if (b == 0) {
                        b = 85;
                    } else if (b == 1) {
                        b = 86;
                    } else {
                        VpnStatus.logDebug(String.format(Locale.US, "Escaped byte not 0 or 1: %d", b));
                        read = logFile.read(buf, 1, 4) + 1;
                        continue block0;
                    }
                }
                buf2[pos++] = b;
            }
            this.restoreLogItem(buf2, len);
            read = logFile.read(buf, 0, 5);
            if (++itemsRead <= 2000) continue;
            VpnStatus.logError("Too many logentries read from cache, aborting.");
            read = 0;
        }
        VpnStatus.logDebug(R.string.reread_log, itemsRead);
    }

    protected void restoreLogItem(byte[] buf, int len) throws UnsupportedEncodingException {
        LogItem li = new LogItem(buf, len);
        if (li.verify()) {
            VpnStatus.newLogItem(li, true);
        } else {
            VpnStatus.logError(String.format(Locale.getDefault(), "Could not read log item from file: %d: %s", len, LogFileHandler.bytesToHex(buf, Math.max(len, 80))));
        }
    }
}

