/*
 * Decompiled with CFR 0.152.
 */
package de.blinkt.openvpn.core;

import android.os.Build;
import android.support.annotation.NonNull;
import de.blinkt.openvpn.BuildConfig;
import de.blinkt.openvpn.core.CIDRIP;
import java.math.BigInteger;
import java.net.Inet6Address;
import java.util.Collection;
import java.util.Locale;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;
import junit.framework.Assert;

public class NetworkSpace {
    TreeSet<ipAddress> mIpAddresses = new TreeSet();

    public Collection<ipAddress> getNetworks(boolean included) {
        Vector<ipAddress> ips = new Vector<ipAddress>();
        for (ipAddress ip : this.mIpAddresses) {
            if (ip.included != included) continue;
            ips.add(ip);
        }
        return ips;
    }

    public void clear() {
        this.mIpAddresses.clear();
    }

    void addIP(CIDRIP cidrIp, boolean include) {
        this.mIpAddresses.add(new ipAddress(cidrIp, include));
    }

    public void addIPSplit(CIDRIP cidrIp, boolean include) {
        ipAddress[] splitIps;
        ipAddress newIP = new ipAddress(cidrIp, include);
        for (ipAddress split : splitIps = newIP.split()) {
            this.mIpAddresses.add(split);
        }
    }

    void addIPv6(Inet6Address address, int mask, boolean included) {
        this.mIpAddresses.add(new ipAddress(address, mask, included));
    }

    TreeSet<ipAddress> generateIPList() {
        PriorityQueue<ipAddress> networks = new PriorityQueue<ipAddress>((SortedSet<ipAddress>)this.mIpAddresses);
        TreeSet<ipAddress> ipsDone = new TreeSet<ipAddress>();
        ipAddress currentNet = networks.poll();
        if (currentNet == null) {
            return ipsDone;
        }
        while (currentNet != null) {
            ipAddress[] newNets;
            ipAddress nextNet = networks.poll();
            if (BuildConfig.DEBUG) {
                Assert.assertNotNull((Object)currentNet);
            }
            if (nextNet == null || currentNet.getLastAddress().compareTo(nextNet.getFirstAddress()) == -1) {
                ipsDone.add(currentNet);
                currentNet = nextNet;
                continue;
            }
            if (currentNet.getFirstAddress().equals(nextNet.getFirstAddress()) && currentNet.networkMask >= nextNet.networkMask) {
                if (currentNet.included == nextNet.included) {
                    currentNet = nextNet;
                    continue;
                }
                newNets = nextNet.split();
                if (!networks.contains(newNets[1])) {
                    networks.add(newNets[1]);
                }
                if (newNets[0].getLastAddress().equals(currentNet.getLastAddress())) {
                    if (!BuildConfig.DEBUG) continue;
                    Assert.assertEquals((int)newNets[0].networkMask, (int)currentNet.networkMask);
                    continue;
                }
                if (networks.contains(newNets[0])) continue;
                networks.add(newNets[0]);
                continue;
            }
            if (BuildConfig.DEBUG) {
                Assert.assertTrue((currentNet.networkMask < nextNet.networkMask ? 1 : 0) != 0);
                Assert.assertTrue((nextNet.getFirstAddress().compareTo(currentNet.getFirstAddress()) == 1 ? 1 : 0) != 0);
                Assert.assertTrue((currentNet.getLastAddress().compareTo(nextNet.getLastAddress()) != -1 ? 1 : 0) != 0);
            }
            if (currentNet.included == nextNet.included) continue;
            newNets = currentNet.split();
            if (newNets[1].networkMask == nextNet.networkMask) {
                if (BuildConfig.DEBUG) {
                    Assert.assertTrue((boolean)newNets[1].getFirstAddress().equals(nextNet.getFirstAddress()));
                    Assert.assertTrue((boolean)newNets[1].getLastAddress().equals(currentNet.getLastAddress()));
                }
                networks.add(nextNet);
            } else {
                networks.add(newNets[1]);
                networks.add(nextNet);
            }
            currentNet = newNets[0];
        }
        return ipsDone;
    }

    Collection<ipAddress> getPositiveIPList() {
        TreeSet<ipAddress> ipsSorted = this.generateIPList();
        Vector<ipAddress> ips = new Vector<ipAddress>();
        for (ipAddress ia : ipsSorted) {
            if (!ia.included) continue;
            ips.add(ia);
        }
        if (Build.VERSION.SDK_INT < 19) {
            for (ipAddress origIp : this.mIpAddresses) {
                if (!origIp.included || ipsSorted.contains(origIp)) continue;
                boolean skipIp = false;
                for (ipAddress calculatedIp : ipsSorted) {
                    if (calculatedIp.included || !origIp.containsNet(calculatedIp)) continue;
                    skipIp = true;
                    break;
                }
                if (skipIp) continue;
                ips.add(origIp);
            }
        }
        return ips;
    }

    static class ipAddress
    implements Comparable<ipAddress> {
        public int networkMask;
        private BigInteger netAddress;
        private boolean included;
        private boolean isV4;
        private BigInteger firstAddress;
        private BigInteger lastAddress;

        public ipAddress(CIDRIP ip, boolean include) {
            this.included = include;
            this.netAddress = BigInteger.valueOf(ip.getInt());
            this.networkMask = ip.len;
            this.isV4 = true;
        }

        public ipAddress(Inet6Address address, int mask, boolean include) {
            this.networkMask = mask;
            this.included = include;
            int s = 128;
            this.netAddress = BigInteger.ZERO;
            for (byte b : address.getAddress()) {
                this.netAddress = this.netAddress.add(BigInteger.valueOf(b & 0xFF).shiftLeft(s -= 8));
            }
        }

        ipAddress(BigInteger baseAddress, int mask, boolean included, boolean isV4) {
            this.netAddress = baseAddress;
            this.networkMask = mask;
            this.included = included;
            this.isV4 = isV4;
        }

        @Override
        public int compareTo(@NonNull ipAddress another) {
            int comp = this.getFirstAddress().compareTo(another.getFirstAddress());
            if (comp != 0) {
                return comp;
            }
            if (this.networkMask > another.networkMask) {
                return -1;
            }
            if (another.networkMask == this.networkMask) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ipAddress)) {
                return super.equals(o);
            }
            ipAddress on = (ipAddress)o;
            return this.networkMask == on.networkMask && on.getFirstAddress().equals(this.getFirstAddress());
        }

        public BigInteger getLastAddress() {
            if (this.lastAddress == null) {
                this.lastAddress = this.getMaskedAddress(true);
            }
            return this.lastAddress;
        }

        public BigInteger getFirstAddress() {
            if (this.firstAddress == null) {
                this.firstAddress = this.getMaskedAddress(false);
            }
            return this.firstAddress;
        }

        private BigInteger getMaskedAddress(boolean one) {
            BigInteger numAddress = this.netAddress;
            int numBits = this.isV4 ? 32 - this.networkMask : 128 - this.networkMask;
            for (int i = 0; i < numBits; ++i) {
                numAddress = one ? numAddress.setBit(i) : numAddress.clearBit(i);
            }
            return numAddress;
        }

        public String toString() {
            if (this.isV4) {
                return String.format(Locale.US, "%s/%d", this.getIPv4Address(), this.networkMask);
            }
            return String.format(Locale.US, "%s/%d", this.getIPv6Address(), this.networkMask);
        }

        public ipAddress[] split() {
            ipAddress firstHalf = new ipAddress(this.getFirstAddress(), this.networkMask + 1, this.included, this.isV4);
            ipAddress secondHalf = new ipAddress(firstHalf.getLastAddress().add(BigInteger.ONE), this.networkMask + 1, this.included, this.isV4);
            if (BuildConfig.DEBUG) {
                Assert.assertTrue((boolean)secondHalf.getLastAddress().equals(this.getLastAddress()));
            }
            return new ipAddress[]{firstHalf, secondHalf};
        }

        String getIPv4Address() {
            if (BuildConfig.DEBUG) {
                Assert.assertTrue((boolean)this.isV4);
                Assert.assertTrue((this.netAddress.longValue() <= 0xFFFFFFFFL ? 1 : 0) != 0);
                Assert.assertTrue((this.netAddress.longValue() >= 0L ? 1 : 0) != 0);
            }
            long ip = this.netAddress.longValue();
            return String.format(Locale.US, "%d.%d.%d.%d", (ip >> 24) % 256L, (ip >> 16) % 256L, (ip >> 8) % 256L, ip % 256L);
        }

        String getIPv6Address() {
            if (BuildConfig.DEBUG) {
                Assert.assertTrue((!this.isV4 ? 1 : 0) != 0);
            }
            BigInteger r = this.netAddress;
            String ipv6str = null;
            boolean lastPart = true;
            while (r.compareTo(BigInteger.ZERO) == 1) {
                long part = r.mod(BigInteger.valueOf(65536L)).longValue();
                if (ipv6str != null || part != 0L) {
                    if (ipv6str == null && !lastPart) {
                        ipv6str = ":";
                    }
                    ipv6str = lastPart ? String.format(Locale.US, "%x", part, ipv6str) : String.format(Locale.US, "%x:%s", part, ipv6str);
                }
                r = r.shiftRight(16);
                lastPart = false;
            }
            if (ipv6str == null) {
                return "::";
            }
            return ipv6str;
        }

        public boolean containsNet(ipAddress network) {
            BigInteger ourFirst = this.getFirstAddress();
            BigInteger ourLast = this.getLastAddress();
            BigInteger netFirst = network.getFirstAddress();
            BigInteger netLast = network.getLastAddress();
            boolean a = ourFirst.compareTo(netFirst) != 1;
            boolean b = ourLast.compareTo(netLast) != -1;
            return a && b;
        }
    }
}

